/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class Handle {
    protected AbstractShape m_Shape;
    protected int m_Id;
    protected Cursor m_Cursor;
    protected Point m_Point = new Point();

    public Handle(AbstractShape abstractShape, int n, Cursor cursor) {
        this.m_Shape = abstractShape;
        this.m_Id = n;
        this.m_Cursor = cursor;
    }

    protected Handle(Handle handle) {
        this.m_Shape = handle.m_Shape;
        this.m_Id = handle.m_Id;
        this.m_Cursor = handle.m_Cursor;
    }

    public int getId() {
        return this.m_Id;
    }

    public void getPos(Point point) {
        this.m_Shape.getHandlePos(this.m_Id, point);
    }

    public void setPos(Point point) {
        this.m_Point.x = AbstractShape.constrainToPixels(point.x);
        this.m_Point.y = AbstractShape.constrainToPixels(point.y);
        this.m_Shape.setHandlePos(this.m_Id, this.m_Point);
    }

    public Cursor getCursor() {
        return this.m_Cursor;
    }

    public Rectangle getBoundingBox() {
        Rectangle rectangle = this.m_Shape.getRect();
        rectangle.x -= 40;
        rectangle.y -= 40;
        rectangle.width += 100;
        rectangle.height += 100;
        return rectangle;
    }

    public abstract void draw(Graphics2D var1);

    public abstract boolean isHit(Point var1);
}

