/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.erd.reportdesigner.shape.Handle;
import com.elixirtech.erd.reportdesigner.shape.SizeHandle;
import com.elixirtech.erd.reportdesigner.shape.UiElementShape;
import com.elixirtech.report2.raw.model.Line;
import com.elixirtech.report2.raw.model.ShapeGroup;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;

public class LineShape
extends UiElementShape {
    private static final int START_HANDLE = 10;
    private static final int END_HANDLE = 11;
    private SizeHandle m_Handle1 = new SizeHandle(this, 10, Cursor.getPredefinedCursor(12));
    private SizeHandle m_Handle2 = new SizeHandle(this, 11, Cursor.getPredefinedCursor(12));

    public void setPoints(Point[] pointArray) {
        Line line = (Line)this.m_Model;
        int n = Math.max(line.getArrowWidth1(), line.getArrowWidth2());
        int n2 = line.getWidth();
        int n3 = Math.max(n / 2, n2 / 2) + 20;
        int n4 = Math.min(pointArray[0].x, pointArray[1].x);
        int n5 = Math.min(pointArray[0].y, pointArray[1].y);
        int n6 = Math.abs(pointArray[0].x - pointArray[1].x);
        int n7 = Math.abs(pointArray[0].y - pointArray[1].y);
        int n8 = n4 - n3;
        int n9 = n5 - n3;
        int n10 = n6 + 2 * n3;
        int n11 = n7 + 2 * n3;
        line.setLeft(n8);
        line.setTop(n9);
        line.setWidth(n10);
        line.setHeight(n11);
        if (pointArray[0].x == n4) {
            line.setX1(this.divisor(n3, n10, line.getDivisor()));
            line.setX2(this.divisor(n10 - n3, n10, line.getDivisor()));
        } else {
            line.setX1(this.divisor(n10 - n3, n10, line.getDivisor()));
            line.setX2(this.divisor(n3, n10, line.getDivisor()));
        }
        if (pointArray[0].y == n5) {
            line.setY1(this.divisor(n3, n11, line.getDivisor()));
            line.setY2(this.divisor(n11 - n3, n11, line.getDivisor()));
        } else {
            line.setY1(this.divisor(n11 - n3, n11, line.getDivisor()));
            line.setY2(this.divisor(n3, n11, line.getDivisor()));
        }
    }

    private int divisor(int n, int n2, int n3) {
        return LineShape.constrainToPixels(n * n3 / n2);
    }

    @Override
    protected void buildHandles(List<Handle> list) {
        list.add(this.m_Handle2);
        list.add(this.m_Handle1);
        super.buildHandles(list);
    }

    @Override
    public int getHandleCount() {
        return super.getHandleCount() + 2;
    }

    @Override
    public Handle getHandle(int n) {
        int n2 = super.getHandleCount();
        if (n < n2) {
            return super.getHandle(n);
        }
        if ((n -= n2) == 0) {
            return this.m_Handle1;
        }
        return this.m_Handle2;
    }

    @Override
    protected void getHandlePos(int n, Point point) {
        Rectangle rectangle = this.getChildRect();
        Line line = (Line)this.m_Model;
        int n2 = line.getDivisor();
        int n3 = Math.min(line.getX1(), n2);
        int n4 = Math.min(line.getY1(), n2);
        int n5 = Math.min(line.getX2(), n2);
        int n6 = Math.min(line.getY2(), n2);
        if (n == 10) {
            point.x = rectangle.x + n3 * rectangle.width / n2;
            point.y = rectangle.y + n4 * rectangle.height / n2;
        } else if (n == 11) {
            point.x = rectangle.x + n5 * rectangle.width / n2;
            point.y = rectangle.y + n6 * rectangle.height / n2;
        } else {
            super.getHandlePos(n, point);
        }
    }

    @Override
    protected void setHandlePos(int n, Point point) {
        int[] nArray = null;
        int[] nArray2 = null;
        if (!(this.getModel().getParent() instanceof ShapeGroup)) {
            nArray = this.getHRulers();
            nArray2 = this.getVRulers();
            this.snapToRulers(point, nArray, nArray2, true);
        }
        if (n >= 10) {
            int n2;
            Rectangle rectangle = this.getChildRect();
            Line line = (Line)this.m_Model;
            int n3 = line.getDivisor();
            int n4 = rectangle.width == 0 ? 0 : (point.x - rectangle.x) * n3 / rectangle.width;
            int n5 = n2 = rectangle.height == 0 ? 0 : (point.y - rectangle.y) * n3 / rectangle.height;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n4 > n3) {
                n4 = n3;
            }
            if (n2 > n3) {
                n2 = n3;
            }
            if (n == 10) {
                line.setX1(n4);
                line.setY1(n2);
            } else if (n == 11) {
                line.setX2(n4);
                line.setY2(n2);
            }
        } else {
            super.setHandlePos(n, point);
        }
    }
}

