/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.erd.reportdesigner.component.ComponentRegistry;
import com.elixirtech.erd.reportdesigner.shape.Handle;
import com.elixirtech.erd.reportdesigner.shape.SizeHandle;
import com.elixirtech.erd.reportdesigner.shape.UiModelElementShape;
import com.elixirtech.report2.raw.model.PageBreak;
import com.elixirtech.report2.raw.model.ShapeGroup;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.List;
import javax.swing.Icon;

public class PageBreakShape
extends UiModelElementShape {
    public static final int GAP = 60;
    private SizeHandle m_LeftHandle = new SizeHandle(this, 0, Cursor.getPredefinedCursor(12));
    private SizeHandle m_RightHandle = new SizeHandle(this, 1, Cursor.getPredefinedCursor(12));
    private static final Stroke DASHED = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{200.0f, 200.0f}, 0.0f);

    @Override
    public String getName() {
        return ((PageBreak)this.m_Model).getName();
    }

    @Override
    public Icon getIcon() {
        Icon icon = ComponentRegistry.getIcon(this.m_Model);
        return icon;
    }

    @Override
    public void setRect(Rectangle rectangle) {
        ((PageBreak)this.m_Model).setPosition(rectangle.y);
    }

    @Override
    public void getRect(Rectangle rectangle) {
        rectangle.x = 0;
        rectangle.y = this.getPosition();
        rectangle.width = this.getWidth();
        rectangle.height = 0;
    }

    protected void buildHandles(List list) {
    }

    @Override
    public int getHandleCount() {
        return 2;
    }

    @Override
    public Handle getHandle(int n) {
        if (n == 0) {
            return this.m_LeftHandle;
        }
        return this.m_RightHandle;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        graphics2D.setColor(Color.darkGray);
        graphics2D.setStroke(DASHED);
        int n = this.getPosition();
        graphics2D.drawLine(0, n, this.getWidth(), n);
    }

    @Override
    public boolean contains(Point point) {
        int n = this.getPosition();
        return point.y >= n - 60 && point.y <= n + 60;
    }

    @Override
    protected void getHandlePos(int n, Point point) {
        point.x = n == 0 ? 200 : this.getWidth() - 200;
        point.y = this.getPosition();
    }

    @Override
    protected void setHandlePos(int n, Point point) {
        Object object;
        if (!(this.getModel().getParent() instanceof ShapeGroup)) {
            object = this.getVRulers();
            this.snapToRulers(point, null, (int[])object, true);
        }
        object = this.getChunk().getShape().getRect();
        int n2 = Math.max(0, point.y);
        n2 = Math.min(object.height, n2);
        ((PageBreak)this.m_Model).setPosition(n2);
    }

    protected int getPosition() {
        return ((PageBreak)this.m_Model).getPosition();
    }

    protected int getWidth() {
        Rectangle rectangle = this.getChunk().getShape().getRect();
        return rectangle.width;
    }
}

