/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.erd.reportdesigner.ERDAction;
import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.tool.SelectionTool;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.ui.tree.TreeUtil;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;

public class ShapeTreeListener
extends MouseAdapter {
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            Point point = mouseEvent.getPoint();
            JTree jTree = (JTree)mouseEvent.getComponent();
            int n = jTree.getRowForLocation(point.x, point.y);
            if (n >= 0) {
                if (!jTree.isRowSelected(n)) {
                    jTree.setSelectionRow(n);
                }
                Chunk.MyTreeModel myTreeModel = (Chunk.MyTreeModel)jTree.getModel();
                ChunkPanel chunkPanel = (ChunkPanel)((Chunk)myTreeModel.getRoot()).getChunkPanel();
                SelectionTool.doubleClick(chunkPanel, mouseEvent);
            }
        }
    }

    protected void doPopup(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        JTree jTree = (JTree)mouseEvent.getComponent();
        int n = jTree.getRowForLocation(point.x, point.y);
        if (n >= 0) {
            if (!jTree.isRowSelected(n)) {
                jTree.setSelectionRow(n);
            }
            Chunk.MyTreeModel myTreeModel = (Chunk.MyTreeModel)jTree.getModel();
            ChunkPanel chunkPanel = (ChunkPanel)((Chunk)myTreeModel.getRoot()).getChunkPanel();
            JPopupMenu jPopupMenu = SelectionTool.current().getPopup(chunkPanel, mouseEvent);
            if (n == 0) {
                jPopupMenu.addSeparator();
                jPopupMenu.add(new ExpandAllAction(jTree));
                jPopupMenu.add(new CollapseAllAction(jTree));
            }
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private static class ExpandAllAction
    extends ERDAction {
        private JTree m_Tree;

        public ExpandAllAction(JTree jTree) {
            super("ShapeTree.ExpandAll");
            this.m_Tree = jTree;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreeUtil.expandAll(this.m_Tree);
        }
    }

    private static class CollapseAllAction
    extends ERDAction {
        private JTree m_Tree;

        public CollapseAllAction(JTree jTree) {
            super("ShapeTree.CollapseAll");
            this.m_Tree = jTree;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 1; i < this.m_Tree.getRowCount(); ++i) {
                this.m_Tree.collapseRow(i);
            }
        }
    }
}

