/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.erd.UIConstants;
import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import com.elixirtech.erd.reportdesigner.shape.Handle;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;

public class SizeHandle
extends Handle {
    public SizeHandle(AbstractShape abstractShape, int n, Cursor cursor) {
        super(abstractShape, n, cursor);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        this.m_Shape.getHandlePos(this.m_Id, this.m_Point);
        if (this.m_Shape.isHandleLocked(this.m_Id)) {
            graphics2D.setColor(Color.gray);
        } else {
            graphics2D.setColor(Color.green);
        }
        graphics2D.fillRect(this.m_Point.x - 40, this.m_Point.y - 40, 80, 80);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(UIConstants.THIN_LINE);
        graphics2D.drawRect(this.m_Point.x - 40, this.m_Point.y - 40, 80, 80);
    }

    @Override
    public boolean isHit(Point point) {
        if (this.m_Shape.isHandleLocked(this.m_Id)) {
            return false;
        }
        this.getPos(this.m_Point);
        int n = point.x - this.m_Point.x;
        int n2 = point.y - this.m_Point.y;
        return Math.abs(n) < 80 && Math.abs(n2) < 80;
    }
}

