/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import com.elixirtech.erd.reportdesigner.shape.UiModelElementShape;
import com.elixirtech.erd.reportdesigner.tool.PasteAction;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.TableSection;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.Icon;

public class TableSectionShape
extends UiModelElementShape {
    private Icon HEADER_ICON = ERDIcons.TABLE_HEADER;
    private Icon BODY_ICON = ERDIcons.TABLE_BODY;
    private Icon FOOTER_ICON = ERDIcons.TABLE_FOOTER;

    @Override
    public boolean isInteractive() {
        return false;
    }

    @Override
    public String getName() {
        String string = this.getModel().getTagName();
        if ("table-header".equals(string)) {
            return I18N.ERD.getString("Shape.TableHeader");
        }
        if ("table-body".equals(string)) {
            return I18N.ERD.getString("Shape.TableBody");
        }
        if ("table-footer".equals(string)) {
            return I18N.ERD.getString("Shape.TableFooter");
        }
        return "";
    }

    @Override
    public Icon getIcon() {
        String string = this.getModel().getTagName();
        if ("table-header".equals(string)) {
            return this.HEADER_ICON;
        }
        if ("table-body".equals(string)) {
            return this.BODY_ICON;
        }
        if ("table-footer".equals(string)) {
            return this.FOOTER_ICON;
        }
        return null;
    }

    @Override
    public boolean isHolder() {
        return true;
    }

    protected void shiftChildren(int n, int n2) {
        Iterator iterator = ((TableSection)this.m_Model).getRawElementIterator();
        if (iterator.hasNext()) {
            Rectangle rectangle = new Rectangle();
            while (iterator.hasNext()) {
                RawModelElement rawModelElement = (RawModelElement)iterator.next();
                AbstractShape abstractShape = (AbstractShape)rawModelElement.getShape();
                if (abstractShape == null) continue;
                abstractShape.getRect(rectangle);
                rectangle.x += n;
                rectangle.y += n2;
                abstractShape.setRect(rectangle);
            }
        }
    }

    public void getChildRect(Rectangle rectangle) {
        this.getRect(rectangle);
    }

    @Override
    public Action[] getPopupActions(Point point) {
        return new Action[]{new PasteAction((ChunkPanel)this.getChunk().getChunkPanel())};
    }

    @Override
    public void sizeToFitChildren() {
    }

    @Override
    public void setRect(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle();
        this.getRect(rectangle2);
        this.m_Model.setLeft(rectangle.x);
        this.m_Model.setTop(rectangle.y);
        this.m_Model.setWidth(rectangle.width);
        this.m_Model.setHeight(rectangle.height);
        this.shiftChildren(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y);
        this.sizeFillChildren();
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        super.draw(graphics2D);
        Iterator iterator = ((TableSection)this.m_Model).getRawElementIterator();
        while (iterator.hasNext()) {
            RawModelElement rawModelElement = (RawModelElement)iterator.next();
            ((AbstractShape)rawModelElement.getShape()).draw(graphics2D);
        }
    }

    protected int getMinHeight() {
        int n = this.m_Model.getTop();
        Rectangle rectangle = new Rectangle();
        Iterator iterator = ((TableSection)this.m_Model).getRawElementIterator();
        while (iterator.hasNext()) {
            RawModelElement rawModelElement = (RawModelElement)iterator.next();
            if (rawModelElement.isFill()) continue;
            AbstractShape abstractShape = (AbstractShape)rawModelElement.getShape();
            abstractShape.getRect(rectangle);
            n = Math.max(n, rectangle.y + rectangle.height);
        }
        return n - this.m_Model.getTop();
    }

    protected void sizeFillChildren() {
        Rectangle rectangle = this.getChildRect();
        Iterator iterator = ((TableSection)this.m_Model).getRawElementIterator();
        while (iterator.hasNext()) {
            RawModelElement rawModelElement = (RawModelElement)iterator.next();
            AbstractShape abstractShape = (AbstractShape)rawModelElement.getShape();
            if (!abstractShape.isFill()) continue;
            abstractShape.setRect(rectangle);
        }
    }

    @Override
    public boolean isHandleLocked(int n) {
        boolean bl = super.isHandleLocked(n);
        if (!bl) {
            return n < 5;
        }
        return bl;
    }
}

