/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import com.elixirtech.erd.reportdesigner.shape.Handle;
import com.elixirtech.erd.reportdesigner.shape.SizeHandle;
import com.elixirtech.erd.reportdesigner.shape.TableSectionShape;
import com.elixirtech.erd.reportdesigner.shape.UiElementShape;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.Table;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Iterator;
import java.util.List;

public class TableShape
extends UiElementShape {
    private static final int HEADER_HEIGHT_HANDLE = 10;
    private static final int FOOTER_HEIGHT_HANDLE = 11;
    private static final int X_OFFSET = 160;
    protected Table m_TableModel;

    @Override
    public void setModel(RawModelElement rawModelElement) {
        this.m_TableModel = (Table)rawModelElement;
        super.setModel(rawModelElement);
    }

    public void getChildRect(Rectangle rectangle) {
        this.getRect(rectangle);
    }

    @Override
    public void sizeToFitChildren() {
        TableSectionShape tableSectionShape = this.getHeaderShape();
        TableSectionShape tableSectionShape2 = this.getBodyShape();
        TableSectionShape tableSectionShape3 = this.getFooterShape();
        Rectangle rectangle = new Rectangle();
        tableSectionShape2.getRect(rectangle);
        int n = rectangle.height;
        if (tableSectionShape != null) {
            tableSectionShape.getRect(rectangle);
            n += rectangle.height;
        }
        if (tableSectionShape3 != null) {
            tableSectionShape3.getRect(rectangle);
            n += rectangle.height;
        }
        if (n > this.m_Model.getHeight()) {
            this.m_Model.setHeight(n);
            this.layoutSections();
        }
    }

    @Override
    public void setRect(Rectangle rectangle) {
        Table table = (Table)this.m_Model;
        int n = table.getBorderWidth();
        if ("None".equals(table.getBorderStyle())) {
            n = 0;
        }
        int n2 = table.getPaddingTop() + (table.isBorderTop() ? n : 0);
        int n3 = table.getPaddingBottom() + (table.isBorderBottom() ? n : 0);
        int n4 = table.getPaddingLeft() + (table.isBorderLeft() ? n : 0);
        int n5 = table.getPaddingRight() + (table.isBorderRight() ? n : 0);
        int n6 = table.getHeader().getHeight();
        int n7 = table.getFooter().getHeight();
        int n8 = n2 + n6 + n7 + n3;
        int n9 = n4 + n5;
        if (rectangle.width < n9) {
            rectangle.width = n9;
        }
        if (rectangle.height < n8) {
            rectangle.height = n8;
        }
        super.setRect(rectangle);
        this.layoutSections();
    }

    protected void layoutSections() {
        Rectangle rectangle = this.getChildRect();
        Rectangle rectangle2 = new Rectangle();
        int n = rectangle.y;
        int n2 = rectangle.height;
        TableSectionShape tableSectionShape = this.getHeaderShape();
        rectangle2.x = rectangle.x;
        rectangle2.y = rectangle.y;
        rectangle2.width = rectangle.width;
        rectangle2.height = this.m_TableModel.getHeader().getHeight();
        tableSectionShape.setRect(rectangle2);
        n += rectangle2.height;
        n2 -= rectangle2.height;
        tableSectionShape = this.getFooterShape();
        rectangle2.x = rectangle.x;
        rectangle2.width = rectangle.width;
        rectangle2.height = this.m_TableModel.getFooter().getHeight();
        rectangle2.y = rectangle.y + rectangle.height - rectangle2.height;
        tableSectionShape.setRect(rectangle2);
        rectangle2.y = rectangle.y + rectangle.height - rectangle2.height;
        tableSectionShape.setRect(rectangle2);
        tableSectionShape = this.getBodyShape();
        rectangle2.x = rectangle.x;
        rectangle2.y = n;
        rectangle2.width = rectangle.width;
        rectangle2.height = n2 -= rectangle2.height;
        tableSectionShape.setRect(rectangle2);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Rectangle rectangle = this.getRect();
        this.setRect(rectangle);
        super.draw(graphics2D);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle);
        Iterator iterator = ((Table)this.m_Model).getRawElementIterator();
        while (iterator.hasNext()) {
            RawModelElement rawModelElement = (RawModelElement)iterator.next();
            ((AbstractShape)rawModelElement.getShape()).draw(graphics2D);
        }
        graphics2D.setClip(shape);
    }

    @Override
    protected void buildHandles(List<Handle> list) {
        list.add(new SizeHandle(this, 10, Cursor.getPredefinedCursor(12)));
        list.add(new SizeHandle(this, 11, Cursor.getPredefinedCursor(12)));
        super.buildHandles(list);
    }

    @Override
    protected void getHandlePos(int n, Point point) {
        switch (n) {
            case 10: {
                int n2 = this.m_TableModel.getBorderWidth();
                if ("None".equals(this.m_TableModel.getBorderStyle())) {
                    n2 = 0;
                }
                point.x = this.m_TableModel.getLeft() + n2 + 160;
                point.y = this.m_TableModel.getTop();
                if (this.m_TableModel.isBorderTop()) {
                    point.y += n2;
                }
                point.y += this.m_TableModel.getPaddingTop();
                point.y += this.m_TableModel.getHeader().getHeight();
                break;
            }
            case 11: {
                int n3 = this.m_TableModel.getBorderWidth();
                if ("None".equals(this.m_TableModel.getBorderStyle())) {
                    n3 = 0;
                }
                point.x = this.m_TableModel.getLeft() + n3 + 160;
                point.y = this.m_TableModel.getTop();
                point.y += this.m_TableModel.getHeight();
                if (this.m_TableModel.isBorderBottom()) {
                    point.y -= n3;
                }
                point.y -= this.m_TableModel.getPaddingBottom();
                point.y -= this.m_TableModel.getFooter().getHeight();
                break;
            }
            default: {
                super.getHandlePos(n, point);
            }
        }
    }

    @Override
    protected void setHandlePos(int n, Point point) {
        switch (n) {
            case 10: {
                int n2;
                int[] nArray = this.getHRulers();
                int[] nArray2 = this.getVRulers();
                this.snapToRulers(point, nArray, nArray2, true);
                Rectangle rectangle = this.getChildRect();
                int n3 = rectangle.y;
                int n4 = rectangle.height;
                int n5 = n4 - this.m_TableModel.getFooter().getHeight() - 105;
                int n6 = point.y - n3;
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n6 > n5) {
                    n6 = n5;
                }
                if ((n2 = this.m_TableModel.getHeader().getHeight()) < n6) {
                    int n7 = Math.max(105, this.getBodyShape().getMinHeight());
                    int n8 = n5 - n7 + 105;
                    if (n6 > n8) {
                        n6 = n8;
                    }
                } else {
                    int n9 = this.getHeaderShape().getMinHeight();
                    if (n6 < n9) {
                        n6 = n9;
                    }
                }
                this.m_TableModel.getHeader().setHeight(n6);
                this.getHeaderShape().sizeToFitChildren();
                this.getBodyShape().sizeToFitChildren();
                this.layoutSections();
                break;
            }
            case 11: {
                int[] nArray = this.getHRulers();
                int[] nArray3 = this.getVRulers();
                this.snapToRulers(point, nArray, nArray3, true);
                Rectangle rectangle = this.getChildRect();
                int n10 = rectangle.y + this.m_TableModel.getHeader().getHeight() + 105;
                int n11 = rectangle.y + rectangle.height;
                if (point.y < n10) {
                    point.y = n10;
                }
                if (point.y > n11) {
                    point.y = n11;
                }
                int n12 = n11 - point.y;
                int n13 = this.m_TableModel.getFooter().getHeight();
                if (n13 < n12) {
                    int n14 = Math.max(105, this.getBodyShape().getMinHeight());
                    int n15 = n11 - n10 - n14 + 105;
                    if (n12 > n15) {
                        n12 = n15;
                    }
                } else {
                    int n16 = this.getFooterShape().getMinHeight();
                    if (n12 < n16) {
                        n12 = n16;
                    }
                }
                this.m_TableModel.getFooter().setHeight(n12);
                this.getFooterShape().sizeToFitChildren();
                this.getBodyShape().sizeToFitChildren();
                this.layoutSections();
                break;
            }
            default: {
                super.setHandlePos(n, point);
            }
        }
    }

    protected TableSectionShape getHeaderShape() {
        return (TableSectionShape)this.m_TableModel.getHeader().getShape();
    }

    protected TableSectionShape getBodyShape() {
        return (TableSectionShape)this.m_TableModel.getBody().getShape();
    }

    protected TableSectionShape getFooterShape() {
        return (TableSectionShape)this.m_TableModel.getFooter().getShape();
    }
}

