/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.erd.reportdesigner.UiRenderer;
import com.elixirtech.erd.reportdesigner.component.ComponentRegistry;
import com.elixirtech.erd.reportdesigner.renderer.RenderContext;
import com.elixirtech.erd.reportdesigner.shape.UiModelElementShape;
import com.elixirtech.erd.reportdesigner.tool.UiElementBeanFactory;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;

public class UiElementShape
extends UiModelElementShape {
    protected UiRenderer m_Renderer;

    @Override
    public void setModel(RawModelElement rawModelElement) {
        assert (rawModelElement != null);
        super.setModel(rawModelElement);
        this.m_Renderer = UiRenderer.getRendererFor(this.m_Model);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        super.draw(graphics2D);
        Rectangle rectangle = new Rectangle();
        this.getRect(rectangle);
        Rectangle rectangle2 = graphics2D.getClipBounds();
        graphics2D.clip(rectangle);
        Chunk chunk = this.getChunk();
        RenderContext renderContext = new RenderContext(graphics2D, this.getReport(), chunk);
        if (this.m_Renderer != null) {
            this.m_Renderer.draw(renderContext, (RawElement)this.m_Model);
        }
        graphics2D.setClip(rectangle2);
    }

    @Override
    public String getName() {
        return ((RawElement)this.m_Model).getName();
    }

    public void setName(String string) {
        ((RawElement)this.m_Model).setName(string);
    }

    @Override
    public void doDoubleClick(Point point) {
        boolean bl = this.getReport().getSecurity().isReadOnly();
        UiElementBeanFactory.showPropertyDialog(this.m_Model, bl);
    }

    @Override
    public Icon getIcon() {
        return ComponentRegistry.getIcon(this.m_Model);
    }

    protected RawReport getReport() {
        return (RawReport)this.m_Model.getResourceProvider();
    }

    @Override
    public Rectangle getChildRect() {
        Rectangle rectangle = new Rectangle();
        this.getRect(rectangle);
        if (this.m_Model instanceof RawElement) {
            RawElement rawElement = (RawElement)this.m_Model;
            int n = rawElement.getBorderWidth();
            if ("None".equals(rawElement.getBorderStyle())) {
                n = 0;
            }
            int n2 = rectangle.x + rectangle.width;
            int n3 = rectangle.y + rectangle.height;
            if (rawElement.isBorderLeft()) {
                rectangle.x += n;
            }
            rectangle.x += rawElement.getPaddingLeft();
            if (rawElement.isBorderTop()) {
                rectangle.y += n;
            }
            rectangle.y += rawElement.getPaddingTop();
            if (rawElement.isBorderRight()) {
                n2 -= n;
            }
            n2 -= rawElement.getPaddingRight();
            if (rawElement.isBorderBottom()) {
                n3 -= n;
            }
            rectangle.width = Math.max(0, n2 - rectangle.x);
            rectangle.height = Math.max(0, (n3 -= rawElement.getPaddingBottom()) - rectangle.y);
        }
        return rectangle;
    }
}

