/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.erd.UIConstants;
import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import com.elixirtech.erd.reportdesigner.shape.Handle;
import com.elixirtech.erd.reportdesigner.shape.MoveHandle;
import com.elixirtech.erd.reportdesigner.shape.SizeHandle;
import com.elixirtech.report2.raw.IChunkPanel;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.ShapeGroup;
import com.elixirtech.ui.StandardColor;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public abstract class UiModelElementShape
extends AbstractShape {
    public static final int MIN_WIDTH = 105;
    public static final int MIN_HEIGHT = 105;
    protected Handle[] m_Handles;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(UiModelElementShape.class);

    public UiModelElementShape() {
    }

    public UiModelElementShape(RawModelElement rawModelElement) {
        this.setModel(rawModelElement);
    }

    @Override
    public void setModel(RawModelElement rawModelElement) {
        super.setModel(rawModelElement);
        this.buildHandles();
    }

    @Override
    public boolean contains(Point point) {
        Rectangle rectangle = new Rectangle();
        this.getRect(rectangle);
        return rectangle.contains(point);
    }

    protected int[] getHRulers() {
        return ((ChunkPanel)this.getChunk().getChunkPanel()).getHRulers();
    }

    protected int[] getVRulers() {
        return ((ChunkPanel)this.getChunk().getChunkPanel()).getVRulers();
    }

    protected Chunk getChunk() {
        RawModelElement rawModelElement = this.m_Model;
        if (rawModelElement.getParent() == null) {
            m_Log.warn((Object)("UiModelElement " + String.valueOf(rawModelElement) + " parent=null"));
        }
        while (rawModelElement != null && !(rawModelElement instanceof Chunk)) {
            rawModelElement = (RawModelElement)rawModelElement.getParent();
        }
        if (rawModelElement == null) {
            m_Log.debug((Object)("getChunk returns null for " + this.m_Model.getTagName()));
            for (rawModelElement = this.m_Model; rawModelElement != null && !(rawModelElement instanceof Chunk); rawModelElement = (RawModelElement)rawModelElement.getParent()) {
                m_Log.debug((Object)("> " + rawModelElement.getTagName()));
            }
            m_Log.debug((Object)"End");
        }
        return (Chunk)rawModelElement;
    }

    @Override
    public void setRect(Rectangle rectangle) {
        this.m_Model.setLeft(rectangle.x);
        this.m_Model.setTop(rectangle.y);
        this.m_Model.setWidth(Math.max(105, rectangle.width));
        this.m_Model.setHeight(Math.max(105, rectangle.height));
    }

    @Override
    public void getRect(Rectangle rectangle) {
        rectangle.x = this.m_Model.getLeft();
        rectangle.y = this.m_Model.getTop();
        rectangle.width = this.m_Model.getWidth();
        rectangle.height = this.m_Model.getHeight();
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        graphics2D.setColor(StandardColor.lookup("ERD-Construction-Line"));
        Rectangle rectangle = new Rectangle();
        this.getRect(rectangle);
        graphics2D.setStroke(UIConstants.THIN_LINE);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
    }

    @Override
    public int getHandleCount() {
        return this.m_Handles.length;
    }

    @Override
    public Handle getHandle(int n) {
        return this.m_Handles[n];
    }

    @Override
    protected void getHandlePos(int n, Point point) {
        Rectangle rectangle = new Rectangle();
        this.getRect(rectangle);
        switch (n) {
            case 0: 
            case 1: {
                point.x = rectangle.x;
                point.y = rectangle.y;
                break;
            }
            case 2: {
                point.x = rectangle.x + rectangle.width - 1;
                point.y = rectangle.y;
                break;
            }
            case 3: {
                point.x = rectangle.x + rectangle.width - 1;
                point.y = rectangle.y + rectangle.height - 1;
                break;
            }
            case 4: {
                point.x = rectangle.x;
                point.y = rectangle.y + rectangle.height - 1;
            }
        }
    }

    @Override
    protected void setHandlePos(int n, Point point) {
        Rectangle rectangle = this.getRect();
        int[] nArray = null;
        int[] nArray2 = null;
        if (!(this.getModel().getParent() instanceof ShapeGroup)) {
            nArray = this.getHRulers();
            nArray2 = this.getVRulers();
            this.snapToRulers(point, nArray, nArray2, true);
        }
        Rectangle rectangle2 = this.getContainerRect();
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y + rectangle.height;
        switch (n) {
            case 0: {
                if (point.x < rectangle2.x) {
                    point.x = rectangle2.x;
                }
                if (point.x + rectangle.width >= rectangle2.x + rectangle2.width) {
                    point.x = rectangle2.x + rectangle2.width - rectangle.width - 1;
                }
                if (point.y < rectangle2.y) {
                    point.y = rectangle2.y;
                }
                if (point.y + rectangle.height >= rectangle2.y + rectangle2.height) {
                    point.y = rectangle2.y + rectangle2.height - rectangle.height - 1;
                }
                rectangle.x = point.x;
                rectangle.y = point.y;
                Point point2 = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                if (!(this.getModel().getParent() instanceof ShapeGroup)) {
                    this.snapToRulers(point2, nArray, nArray2, false);
                }
                rectangle.x = point2.x - rectangle.width;
                rectangle.y = point2.y - rectangle.height;
                break;
            }
            case 1: {
                if (point.x < rectangle2.x) {
                    point.x = rectangle2.x;
                }
                if (point.x + 105 > n2) {
                    point.x = n2 - 105;
                }
                if (point.y < rectangle2.y) {
                    point.y = rectangle2.y;
                }
                if (point.y + 105 > n3) {
                    point.y = n3 - 105;
                }
                rectangle.x = point.x;
                rectangle.y = point.y;
                rectangle.width = n2 - point.x;
                rectangle.height = n3 - point.y;
                break;
            }
            case 2: {
                if (point.x >= rectangle2.x + rectangle2.width) {
                    point.x = rectangle2.x + rectangle2.width - 1;
                }
                if (point.x - 105 < rectangle.x) {
                    point.x = rectangle.x + 105;
                }
                if (point.y < rectangle2.y) {
                    point.y = rectangle2.y;
                }
                if (point.y + 105 > n3) {
                    point.y = n3 - 105;
                }
                rectangle.width = point.x - rectangle.x;
                rectangle.y = point.y;
                rectangle.height = n3 - point.y;
                break;
            }
            case 3: {
                if (point.x >= rectangle2.x + rectangle2.width) {
                    point.x = rectangle2.x + rectangle2.width - 1;
                }
                if (point.x - 105 < rectangle.x) {
                    point.x = rectangle.x + 105;
                }
                if (point.y >= rectangle2.y + rectangle2.height) {
                    point.y = rectangle2.y + rectangle2.height - 1;
                }
                if (point.y - 105 < rectangle.y) {
                    point.y = rectangle.y + 105;
                }
                rectangle.width = point.x - rectangle.x;
                rectangle.height = point.y - rectangle.y;
                break;
            }
            case 4: {
                if (point.x < rectangle2.x) {
                    point.x = rectangle2.x;
                }
                if (point.x + 105 > n2) {
                    point.x = n2 - 105;
                }
                if (point.y >= rectangle2.y + rectangle2.height) {
                    point.y = rectangle2.y + rectangle2.height - 1;
                }
                if (point.y - 105 < rectangle.y) {
                    point.y = rectangle.y + 105;
                }
                rectangle.x = point.x;
                rectangle.width = n2 - point.x;
                rectangle.height = point.y - rectangle.y;
            }
        }
        this.setRect(rectangle);
    }

    protected void buildHandles() {
        ArrayList<Handle> arrayList = new ArrayList<Handle>();
        this.buildHandles(arrayList);
        this.m_Handles = new Handle[arrayList.size()];
        arrayList.toArray(this.m_Handles);
    }

    protected void buildHandles(List<Handle> list) {
        list.add(new SizeHandle(this, 1, Cursor.getPredefinedCursor(6)));
        list.add(new SizeHandle(this, 2, Cursor.getPredefinedCursor(7)));
        list.add(new SizeHandle(this, 3, Cursor.getPredefinedCursor(5)));
        list.add(new SizeHandle(this, 4, Cursor.getPredefinedCursor(4)));
        list.add(new MoveHandle(this, 0));
    }

    protected Rectangle getContainerRect() {
        AbstractShape abstractShape = (AbstractShape)this.m_Model.getParent().getShape();
        if (abstractShape != null) {
            return abstractShape.getRect();
        }
        return null;
    }

    protected void snapToRulers(Point point, int[] nArray, int[] nArray2, boolean bl) {
        Chunk chunk = this.getChunk();
        IChunkPanel iChunkPanel = chunk.getChunkPanel();
        if (iChunkPanel.isRulersEnabled()) {
            RawReport rawReport = (RawReport)chunk.getResourceProvider();
            UiModelElementShape.snapToRulers(rawReport, point, nArray, nArray2, bl);
        }
    }

    protected static void snapToRulers(RawReport rawReport, Point point, int[] nArray, int[] nArray2, boolean bl) {
        int n;
        boolean bl2 = bl && rawReport.isGridEnabled();
        int n2 = bl2 ? rawReport.getGridX() : 0;
        int n3 = bl2 ? rawReport.getGridY() : 0;
        boolean bl3 = false;
        if (nArray != null) {
            for (n = 0; n < nArray.length; ++n) {
                if (Math.abs(point.x - nArray[n]) >= 80) continue;
                point.x = nArray[n];
                bl3 = true;
                break;
            }
        }
        if (!bl3 && n2 > 1) {
            point.x -= point.x % n2;
        }
        n = 0;
        if (nArray2 != null) {
            for (int i = 0; i < nArray2.length; ++i) {
                if (Math.abs(point.y - nArray2[i]) >= 80) continue;
                point.y = nArray2[i];
                n = 1;
                break;
            }
        }
        if (n == 0 && n3 > 1) {
            point.y -= point.y % n3;
        }
    }

    @Override
    public abstract String getName();

    @Override
    public abstract Icon getIcon();

    @Override
    public void dispose() {
    }
}

