/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.shape;

import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import com.elixirtech.erd.reportdesigner.shape.BoxShape;
import com.elixirtech.erd.reportdesigner.shape.CellShape;
import com.elixirtech.erd.reportdesigner.shape.Handle;
import com.elixirtech.erd.reportdesigner.shape.SizeHandle;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Cell;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.VBox;
import com.elixirtech.util.StringUtil;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;

public class VBoxShape
extends BoxShape {
    private static final int HANDLE_START = 100;
    private static final int X_OFFSET = 160;
    protected VBox m_VBoxModel;
    private static Icon m_Icon = ERDIcons.VERTICAL_BOX;

    @Override
    public void setModel(RawModelElement rawModelElement) {
        this.m_VBoxModel = (VBox)rawModelElement;
        super.setModel(rawModelElement);
    }

    @Override
    public String getName() {
        String string = this.m_VBoxModel.getName();
        if (StringUtil.notEmpty(string)) {
            return string;
        }
        return I18N.ERD.getString("Shape.VerticalBox");
    }

    @Override
    public Icon getIcon() {
        return m_Icon;
    }

    public void getChildRect(Rectangle rectangle) {
        this.getRect(rectangle);
    }

    @Override
    public void sizeToFitChildren() {
    }

    @Override
    public void setRect(Rectangle rectangle) {
        super.setRect(rectangle);
        this.layoutCells();
    }

    @Override
    public void layoutCells() {
        Rectangle rectangle = new Rectangle();
        this.getRect(rectangle);
        int n = rectangle.y;
        Rectangle rectangle2 = new Rectangle();
        long l = this.getTotalWeight();
        Iterator iterator = this.m_VBoxModel.getCellIterator();
        while (iterator.hasNext()) {
            Cell cell = (Cell)iterator.next();
            long l2 = cell.getWeight();
            CellShape cellShape = (CellShape)cell.getShape();
            rectangle2.x = rectangle.x;
            rectangle2.y = n;
            rectangle2.width = rectangle.width;
            rectangle2.height = l == 0L ? 0 : (int)(l2 * (long)rectangle.height / l);
            l -= l2;
            rectangle.height -= rectangle2.height;
            cellShape.setRect(rectangle2);
            n += rectangle2.height;
        }
        this.buildHandles();
    }

    @Override
    protected void buildHandles(List<Handle> list) {
        int n = this.m_VBoxModel.getCellCount();
        for (int i = n - 2; i >= 0; --i) {
            list.add(new SizeHandle(this, 100 + i, Cursor.getPredefinedCursor(12)));
        }
        super.buildHandles(list);
    }

    @Override
    protected void getHandlePos(int n, Point point) {
        if (n >= 100) {
            int n2 = n - 100;
            Cell cell = this.m_VBoxModel.getCell(n2);
            CellShape cellShape = (CellShape)cell.getShape();
            Rectangle rectangle = new Rectangle();
            ((AbstractShape)cellShape).getRect(rectangle);
            point.x = rectangle.x + 160;
            point.y = rectangle.y + rectangle.height;
        } else {
            super.getHandlePos(n, point);
        }
    }

    @Override
    protected void setHandlePos(int n, Point point) {
        if (n >= 100) {
            Iterator iterator;
            int[] nArray = this.getVRulers();
            this.snapToRulers(point, null, nArray, true);
            int n2 = n - 100;
            Cell cell = this.m_VBoxModel.getCell(n2);
            Rectangle rectangle = new Rectangle();
            this.getRect(rectangle);
            while (this.getTotalWeight() < (long)rectangle.height) {
                iterator = this.m_VBoxModel.getCellIterator();
                while (iterator.hasNext()) {
                    Cell cell2 = (Cell)iterator.next();
                    cell2.setWeight(Math.max(1, cell2.getWeight() * 10));
                }
            }
            iterator = this.m_VBoxModel.getCell(n2 + 1);
            int n3 = cell.getTop();
            int n4 = n3 + 80;
            int n5 = iterator.getTop() + iterator.getHeight() - 80;
            point.y = Math.max(point.y, n4);
            point.y = Math.min(point.y, n5);
            int n6 = Math.max(80, point.y - n3);
            int n7 = cell.getWeight() + iterator.getWeight();
            int n8 = cell.getHeight() + iterator.getHeight();
            int n9 = n7 * n6 / n8;
            cell.setWeight(n9);
            iterator.setWeight(n7 - n9);
            this.layoutCells();
        } else {
            super.setHandlePos(n, point);
        }
    }
}

