/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.style;

import com.elixirtech.arch.Elixir;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.IMasterPropertyList;
import com.elixirtech.property.PropertyData;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.TitledBorder;
import java.awt.BorderLayout;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;

class AllPropertiesPanel
extends JPanel {
    private JList m_List;

    public AllPropertiesPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new JLabel(I18N.ERD.getString("AllPropertiesPanel.all-properties"))));
        this.m_List = SwingFactory.newList("properties-list", this.getPropertyNameListModel());
        this.m_List.setFont(UIManager.getFont("TextField.font"));
        this.add(SwingFactory.newScrollPane("properties-scrollpane", this.m_List));
        I18N.ERD_MAP.injectComponents("AllPropertiesPanel.", this);
    }

    public Name[] getNames() {
        Object[] objectArray = this.m_List.getSelectedValues();
        Name[] nameArray = new Name[objectArray.length];
        for (int i = 0; i < nameArray.length; ++i) {
            nameArray[i] = (Name)objectArray[i];
        }
        return nameArray;
    }

    private Vector<Name> getPropertyNameListModel() {
        IMasterPropertyList iMasterPropertyList = (IMasterPropertyList)Elixir.get(IMasterPropertyList.class);
        Vector<Name> vector = new Vector<Name>();
        TreeSet<Name> treeSet = new TreeSet<Name>();
        for (PropertyData propertyData : iMasterPropertyList.getPropertyData()) {
            if (!propertyData.styleable) continue;
            treeSet.add(propertyData.name);
        }
        for (Name name : treeSet) {
            vector.addElement(name);
        }
        return vector;
    }
}

