/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.style;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.repository.RepositoryTree;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.StylesheetRef;
import com.elixirtech.repository.ExtraTodo;
import com.elixirtech.repository.TreeNode;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.OnePageWizard;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class ChooseStylesheetPage
extends RelativeLayoutWizardPage
implements OnePageWizard.Page {
    private RepositoryTree m_Tree;
    private RawReport m_RawReport;

    public static IWizard getOnePageWizard(RawReport rawReport) {
        return new OnePageWizard("Choose stylesheet", new ChooseStylesheetPage(rawReport));
    }

    public ChooseStylesheetPage(RawReport rawReport) {
        super("Choose Stylesheet", null);
        this.m_RawReport = rawReport;
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        Repository repository = (Repository)Elixir.get(Repository.class);
        RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
        FileType fileType = repositoryExplorer.getFileTypeJ("application/x-repository-stylesheet");
        this.m_Tree = RepositoryTree.apply("ChooseStylesheetWizard", repository, fileType);
        this.m_Component.add(SwingFactory.newScrollPane("tree", this.m_Tree));
        this.stickLeft("tree");
        this.stickTop("tree");
        this.stickRight("tree");
        this.stickBottom("tree");
        this.m_Tree.getSelectionModel().addTreeSelectionListener(new TSL());
        I18N.ERD_MAP.injectComponents("ChooseStylesheetPage.", this.m_Component);
        I18N.ERD_MAP.injectObject(null, this, "ChooseStylesheetPage");
    }

    @Override
    public boolean isPageComplete() {
        this.setError(null);
        FileObject fileObject = this.m_Tree.getSelectionJ();
        if (fileObject == null) {
            this.setError(I18N.ERD.getString("ChooseStylesheetPage.error-style"));
        }
        this.m_Wizard.getContainer().updateMessage();
        return fileObject != null;
    }

    public void itemSelected(FileObject fileObject) {
        this.m_Wizard.getContainer().updateButtons();
    }

    @Override
    public boolean performFinish() {
        StylesheetRef stylesheetRef = new StylesheetRef();
        stylesheetRef.setName(this.m_Tree.getSelectionJ().getPath().toString());
        this.m_RawReport.addStylesheet(stylesheetRef);
        return true;
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public void dispose() {
        if (this.m_Tree != null) {
            this.m_Tree.dispose();
        }
        super.dispose();
    }

    private class TSL
    implements TreeSelectionListener {
        private TSL() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getPath();
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            FileObject fileObject = ExtraTodo.getFileObject(treeNode);
            ChooseStylesheetPage.this.itemSelected(fileObject);
        }
    }
}

