/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.style;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.erd.reportdesigner.style.StylesEditor;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.OnePageWizard;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class StylePage
extends WizardPage
implements OnePageWizard.Page {
    private RawReport m_Report;
    private Style m_Style;
    private Style m_WorkingStyle;
    private JTextField m_StyleName;
    private JComboBox m_StyleBase;
    private StylesEditor m_Editor;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(StylePage.class);

    public static IWizard getWizard(RawReport rawReport, Style style) {
        OnePageWizard onePageWizard = new OnePageWizard(I18N.ERD.getString("StylePageWizard.title"), new StylePage(rawReport, style));
        onePageWizard.setStandardSize(false);
        onePageWizard.setReadOnly(rawReport.getSecurity().isReadOnly());
        return onePageWizard;
    }

    public StylePage(RawReport rawReport, Style style) {
        super("StylePage", null);
        boolean bl = rawReport.getStyleMap().values().contains(style);
        if (bl) {
            this.setTitle(I18N.ERD.getString("StylePage.title.edit"));
        } else {
            this.setTitle(I18N.ERD.getString("StylePage.title.add"));
        }
        this.setMessage(I18N.ERD.getString("StylePage.message"));
        this.m_Report = rawReport;
        this.m_Style = style;
        try {
            this.m_WorkingStyle = new Style(this.m_Style);
        }
        catch (Exception exception) {
            m_Log.error((Object)"Can't create local copy of Style");
        }
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Component.setLayout(new BorderLayout());
        Box box = Box.createHorizontalBox();
        box.add(SwingFactory.newLabel("UI.name"));
        box.add(Box.createHorizontalStrut(5));
        this.m_StyleName = SwingFactory.newTextField("name");
        this.m_StyleName.setText(this.m_Style.getName());
        this.m_StyleName.getDocument().addDocumentListener(new FieldWatcher(this.m_Wizard));
        box.add(this.m_StyleName);
        box.add(Box.createHorizontalStrut(5));
        box.add(SwingFactory.newLabel("base"));
        box.add(Box.createHorizontalStrut(5));
        this.m_StyleBase = SwingFactory.newComboBox("base-name", this.getBaseNames());
        box.add(this.m_StyleBase);
        this.m_StyleBase.setSelectedItem(this.m_Style.getBaseName());
        box.add(Box.createHorizontalStrut(5));
        box.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.m_Editor = new StylesEditor(this.m_WorkingStyle);
        this.m_Component.add((Component)box, "North");
        this.m_Component.add(this.m_Editor);
        I18N.ERD_MAP.injectComponents("StylePage.", this.m_Component);
    }

    @Override
    public boolean isPageComplete() {
        Style style;
        boolean bl = true;
        this.setError(null);
        String string = this.m_StyleName.getText();
        if (StringUtil.isEmpty(string)) {
            this.setError(I18N.ERD.getString("StylesheetPage.name-required"));
            bl = false;
        }
        if ((style = this.m_Report.getStyle(string)) != null && style != this.m_Style) {
            this.setError(I18N.ERD.getString("StylesheetPage.name-notunique"));
            bl = false;
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    @Override
    public boolean performFinish() {
        this.m_Editor.setCurrent(false);
        String string = this.m_Style.getName();
        String string2 = this.m_StyleName.getText();
        if (!string.equals(string2)) {
            this.m_Report.removeStyle(this.m_Style);
            this.m_Style.setName(string2);
            this.m_Report.renameStyle(string, string2);
            this.m_Report.addStyle(this.m_Style);
        }
        this.m_Style.setBaseName((String)this.m_StyleBase.getSelectedItem());
        this.m_Style.setStyleItemMap(this.m_WorkingStyle.getStyleItemMap());
        if (this.m_Style.getParent() == null) {
            this.m_Report.addStyle(this.m_Style);
        }
        this.m_Report.setDirty(true);
        return true;
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    private String[] getBaseNames() {
        String[] stringArray;
        String string = this.m_Style.getName();
        Map map = this.m_Report.getStyleMap();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        treeSet.addAll(map.keySet());
        treeSet.remove(string);
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            if (!this.dependsOn(map, (String)stringArray, string)) continue;
            iterator.remove();
        }
        treeSet.add("");
        stringArray = new String[treeSet.size()];
        treeSet.toArray(stringArray);
        return stringArray;
    }

    private boolean dependsOn(Map<String, Style> map, String string, String string2) {
        Style style = map.get(string);
        if (style == null) {
            return false;
        }
        String string3 = style.getBaseName();
        if (StringUtil.isEmpty(string3)) {
            return false;
        }
        if (string3.equals(string2)) {
            return true;
        }
        return this.dependsOn(map, string3, string2);
    }
}

