/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.style;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.erd.images.Icons;
import com.elixirtech.erd.reportdesigner.ReportTab;
import com.elixirtech.erd.reportdesigner.report.ReportTreeActions;
import com.elixirtech.erd.reportdesigner.report.ReportTreeModel;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.sax.ChangeListener;
import com.elixirtech.sax.ChangeNotifier;
import com.elixirtech.ui.tree.TreeModelEx;
import com.elixirtech.ui.tree.TreeSupport;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class StyleTree
implements ChangeListener {
    final JPanel m_Panel;
    final RawReport m_Report;
    final StyleTreeModel m_TreeModel;
    final JTree m_Tree;
    final List<Style> m_Wrappers = new ArrayList<Style>();

    public StyleTree(RawReport rawReport) {
        this.m_Panel = new JPanel(new BorderLayout());
        this.m_Report = rawReport;
        this.m_TreeModel = new StyleTreeModel();
        this.m_Tree = new JTree(this.m_TreeModel);
        this.m_Tree.setMinimumSize(new Dimension(50, 50));
        this.m_Tree.expandRow(0);
        new TreeSupport(this.m_Tree, false);
        this.m_Panel.add(new JScrollPane(this.m_Tree));
        this.m_Report.addChangeListener((ChangeListener)this);
    }

    public JComponent getComponent() {
        return this.m_Panel;
    }

    public void beanChanged(ChangeNotifier changeNotifier, String string) {
        if ("RawReport.Style".equals(string)) {
            this.refresh();
        }
    }

    public void refresh() {
        this.m_TreeModel.refresh();
    }

    public class StyleTreeModel
    implements TreeModelEx {
        private List<TreeModelListener> m_Listeners = new ArrayList<TreeModelListener>();

        public StyleTreeModel() {
            this.refresh();
        }

        public void refresh() {
            Map map = StyleTree.this.m_Report.getStyleMap();
            TreeSet treeSet = new TreeSet();
            treeSet.addAll(StyleTree.this.m_Report.getStyleMap().keySet());
            StyleTree.this.m_Wrappers.clear();
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                StyleTree.this.m_Wrappers.add((Style)map.get(iterator.next()));
            }
            this.fireTreeChanged();
        }

        @Override
        public Object getRoot() {
            return StyleTree.this.m_Report;
        }

        @Override
        public int getChildCount(Object object) {
            if (object == StyleTree.this.m_Report) {
                return StyleTree.this.m_Wrappers.size();
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object object) {
            if (object == StyleTree.this.m_Report) {
                return StyleTree.this.m_Wrappers.size() == 0;
            }
            return true;
        }

        @Override
        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.m_Listeners.add(treeModelListener);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.m_Listeners.remove(treeModelListener);
        }

        @Override
        public Object getChild(Object object, int n) {
            if (object == StyleTree.this.m_Report) {
                return StyleTree.this.m_Wrappers.get(n);
            }
            return null;
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            if (object == StyleTree.this.m_Report) {
                return StyleTree.this.m_Wrappers.indexOf(object2);
            }
            return -1;
        }

        @Override
        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        protected void fireTreeChanged() {
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new TreePath(StyleTree.this.m_Report));
            for (TreeModelListener treeModelListener : this.m_Listeners) {
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
        }

        @Override
        public Icon getIcon(Object object) {
            return Icons.STYLE;
        }

        @Override
        public String getLabel(Object object) {
            if (object instanceof RawReport) {
                return I18N.ERD.getString("ReportTree.Styles");
            }
            if (object instanceof Style) {
                return ((Style)object).getName();
            }
            return null;
        }

        @Override
        public void setLabel(Object object, String string) {
        }

        @Override
        public JPopupMenu getPopupMenu(Object object) {
            if (object instanceof RawReport) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                ReportTreeModel reportTreeModel = this.getReportTreeModel();
                jPopupMenu.add(new ReportTreeActions.AddStyle(reportTreeModel));
                jPopupMenu.add(new ReportTreeActions.Paste(reportTreeModel));
                return jPopupMenu;
            }
            if (object instanceof Style) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                ReportTreeModel reportTreeModel = this.getReportTreeModel();
                Style style = (Style)object;
                jPopupMenu.add(new ReportTreeActions.EditStyle(reportTreeModel, style));
                jPopupMenu.add(new ReportTreeActions.Copy(reportTreeModel, style));
                ReportTreeActions.Delete delete = new ReportTreeActions.Delete(reportTreeModel, style);
                jPopupMenu.add(delete);
                return jPopupMenu;
            }
            return null;
        }

        @Override
        public void doDoubleClick(Object object) {
            if (object instanceof Style) {
                ReportTreeModel reportTreeModel = this.getReportTreeModel();
                Style style = (Style)object;
                ReportTreeActions.EditStyle editStyle = new ReportTreeActions.EditStyle(reportTreeModel, style);
                editStyle.actionPerformed(null);
            }
        }

        private ReportTreeModel getReportTreeModel() {
            IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
            ReportTab reportTab = (ReportTab)iViewModel.getCurrentView();
            return reportTab.getReportPanel().getReportTreeModel();
        }
    }
}

