/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.style;

import com.elixirtech.arch.Elixir;
import com.elixirtech.erd.reportdesigner.style.AllPropertiesPanel;
import com.elixirtech.erd.reportdesigner.style.StylePropertiesPanel;
import com.elixirtech.i18n.Name;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.property.IMasterPropertyList;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.property.PropertyNode;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.report2.raw.model.StyleItem;
import com.elixirtech.ui.CurrentTab;
import com.elixirtech.util.CodeBlock;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;

public class StylesEditor
extends JPanel
implements CurrentTab {
    private IMasterPropertyList m_MasterPropertyList;
    private AllPropertiesPanel m_AllProperties;
    private StylePropertiesPanel m_StyleProperties;
    private Style m_CurrentStyle;
    private JButton m_Add;
    private JButton m_Remove;
    private JButton m_RemoveAll;

    public StylesEditor(Style style) {
        this.m_CurrentStyle = style;
        this.m_MasterPropertyList = (IMasterPropertyList)Elixir.get(IMasterPropertyList.class);
        this.setLayout(new BorderLayout());
        Box box = Box.createHorizontalBox();
        this.m_AllProperties = new AllPropertiesPanel();
        box.add(this.m_AllProperties);
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        this.m_Add = new JButton(StandardIcons.RIGHT);
        this.m_Add.addActionListener(new CodeBlock((Object)this, "addProperty"));
        jPanel.add(this.m_Add);
        this.m_Remove = new JButton(StandardIcons.LEFT);
        this.m_Remove.addActionListener(new CodeBlock((Object)this, "removeProperty"));
        jPanel.add(this.m_Remove);
        this.m_RemoveAll = new JButton(StandardIcons.LEFT_ALL);
        this.m_RemoveAll.addActionListener(new CodeBlock((Object)this, "removeAllProperties"));
        jPanel.add(this.m_RemoveAll);
        box.add(jPanel);
        this.m_StyleProperties = new StylePropertiesPanel();
        ArrayList<PropertyHolder> arrayList = new ArrayList<PropertyHolder>();
        arrayList.add((PropertyHolder)this.m_CurrentStyle);
        this.m_StyleProperties.setPropertyHolders(arrayList);
        box.add(this.m_StyleProperties);
        this.add(box);
    }

    @Override
    public void setCurrent(boolean bl) {
        if (!bl) {
            this.m_StyleProperties.disposeEditor();
        }
    }

    public void addProperty() {
        try {
            Name[] nameArray = this.m_AllProperties.getNames();
            for (int i = 0; i < nameArray.length; ++i) {
                PropertyType propertyType = this.m_MasterPropertyList.getPropertyType(nameArray[i]);
                Object object = this.m_MasterPropertyList.getDefaultValue(nameArray[i]);
                StyleItem styleItem = new StyleItem();
                styleItem.setName(nameArray[i].getName());
                styleItem.setValue(propertyType.toString(object));
                this.m_CurrentStyle.addStyleItem(styleItem);
            }
            this.updatePropertyTable();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeProperty() {
        Map map = this.m_CurrentStyle.getStyleItemMap();
        for (PropertyNode propertyNode : this.m_StyleProperties.getSelectedProperties()) {
            map.remove(propertyNode.getName().getName());
        }
        this.updatePropertyTable();
    }

    public void removeAllProperties() {
        this.m_CurrentStyle.getStyleItemMap().clear();
        this.updatePropertyTable();
    }

    private void updatePropertyTable() {
        ArrayList<PropertyHolder> arrayList = new ArrayList<PropertyHolder>();
        arrayList.add((PropertyHolder)this.m_CurrentStyle);
        this.m_StyleProperties.setPropertyHolders(arrayList);
    }
}

