/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.style;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IDirtyState;
import com.elixirtech.erd.reportdesigner.style.AllPropertiesPanel;
import com.elixirtech.erd.reportdesigner.style.StylePropertiesPanel;
import com.elixirtech.erd.util.ClipboardUtil;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.IMasterPropertyList;
import com.elixirtech.property.IStyle;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.property.PropertyNode;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.IStyleManager;
import com.elixirtech.report2.raw.model.Holder;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.report2.raw.model.StyleItem;
import com.elixirtech.sax.ChangeListener;
import com.elixirtech.sax.ChangeNotifier;
import com.elixirtech.ui.ComboUtil;
import com.elixirtech.ui.CurrentTab;
import com.elixirtech.ui.EditableTable;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.TitledBorder;
import com.elixirtech.ui.property.PropertyTableListener;
import com.elixirtech.ui.table.BasicTableEditor;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.util.CodeBlock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StylesPanel
extends JPanel
implements ActionListener,
ChangeListener,
ListSelectionListener,
CurrentTab,
IDirtyState {
    IStyleManager m_StyleManager;
    private IMasterPropertyList m_MasterPropertyList;
    private EditableTable m_Table;
    private StyleModel m_Model;
    private AllPropertiesPanel m_AllProperties;
    private StylePropertiesPanel m_StyleProperties;
    private List<Style> m_Styles = new ArrayList<Style>();
    private Style m_CurrentStyle;
    private JButton m_Add;
    private JButton m_Remove;
    private JButton m_RemoveAll;
    private boolean m_IsDirty;
    private List<IDirtyState.Listener> m_DirtyListeners;
    static final String[] S_COLUMNS = new String[]{"TableModel.Name", "TableModel.Base"};
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(StylesPanel.class);

    public StylesPanel(IStyleManager iStyleManager) {
        this.m_StyleManager = iStyleManager;
        this.m_MasterPropertyList = (IMasterPropertyList)Elixir.get(IMasterPropertyList.class);
        this.setLayout(new BorderLayout());
        this.m_Model = new StyleModel();
        this.m_Table = new EditableTable(this.m_Model, false);
        this.m_Table.setSingleSelectionMode();
        this.m_Table.setBorder(new TitledBorder(SwingFactory.newLabel("styles")));
        this.m_Table.getTable().setDefaultRenderer(Style.class, new StyleComboRenderer());
        this.m_Table.getTable().setDefaultEditor(Style.class, new StyleComboRenderer());
        this.m_Table.setAutoCreateColumns(false);
        this.m_Table.addActionListener(this);
        this.m_Table.addListSelectionListener(this);
        Box box = Box.createHorizontalBox();
        this.m_AllProperties = new AllPropertiesPanel();
        box.add(this.m_AllProperties);
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        this.m_Add = SwingFactory.newButton("ARROW.right.text", new CodeBlock((Object)this, "addProperty"));
        jPanel.add(this.m_Add);
        this.m_Add.setEnabled(false);
        this.m_Remove = SwingFactory.newButton("ARROW.left.text", new CodeBlock((Object)this, "removeProperty"));
        jPanel.add(this.m_Remove);
        this.m_Remove.setEnabled(false);
        jPanel.add(this.m_Remove);
        this.m_RemoveAll = new JButton("<<");
        this.m_RemoveAll.setEnabled(false);
        this.m_RemoveAll.addActionListener(new CodeBlock((Object)this, "removeAllProperties"));
        jPanel.add(this.m_RemoveAll);
        box.add(jPanel);
        this.m_StyleProperties = new StylePropertiesPanel();
        this.m_StyleProperties.addPropertyTableListener(new PTL());
        box.add(this.m_StyleProperties);
        this.add(SwingFactory.newVerticalSplit(this.m_Table, box));
        I18N.ERD_MAP.injectComponents("StylesPanel.", this);
    }

    @Override
    public void setCurrent(boolean bl) {
        if (!bl) {
            this.m_Table.disposeEditor();
        }
    }

    public void beanChanged(ChangeNotifier changeNotifier, String string) {
        if (string.equals("RawReport.Style")) {
            this.m_Model.refresh();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("plus".equals(string)) {
            Style style = new Style();
            style.setName(this.getNextName());
            this.m_Model.addStyle(style);
            this.m_Table.select(this.m_Model.indexOfStyle(style));
            this.setDirty(true);
        } else if ("minus".equals(string)) {
            int n;
            int[] nArray = this.m_Table.getSelectedRows();
            Style[] styleArray = new Style[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                styleArray[n] = this.m_Model.getStyle(nArray[n]);
            }
            for (n = 0; n < styleArray.length; ++n) {
                this.m_Model.removeStyle(styleArray[n]);
            }
            this.setDirty(true);
        } else if ("copy".equals(string)) {
            int[] nArray = this.m_Table.getSelectedRows();
            Holder holder = new Holder();
            for (int i = 0; i < nArray.length; ++i) {
                holder.addContent((Object)this.m_Styles.get(nArray[i]));
            }
            ClipboardUtil.setHolder(holder);
        } else if ("paste".equals(string)) {
            Holder holder = ClipboardUtil.getHolder();
            Iterator iterator = holder.getContentIterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Style)) continue;
                Style style = (Style)e;
                this.findFreeName(style);
                this.m_Model.addStyle(style);
                this.m_Table.select(this.m_Model.indexOfStyle(style));
            }
            this.setDirty(true);
        } else if ("up".equals(string)) {
            int n = this.m_Table.getSelectedRow();
            this.m_Table.select(this.m_Model.moveUp(n));
        } else if ("down".equals(string)) {
            int n = this.m_Table.getSelectedRow();
            this.m_Table.select(this.m_Model.moveDown(n));
        }
    }

    public void addProperty() {
        try {
            if (this.m_CurrentStyle != null) {
                Name[] nameArray = this.m_AllProperties.getNames();
                for (int i = 0; i < nameArray.length; ++i) {
                    PropertyType propertyType = this.m_MasterPropertyList.getPropertyType(nameArray[i]);
                    Object object = this.m_MasterPropertyList.getDefaultValue(nameArray[i]);
                    StyleItem styleItem = new StyleItem();
                    styleItem.setName(nameArray[i].getName());
                    styleItem.setValue(propertyType.toString(object));
                    this.m_CurrentStyle.addStyleItem(styleItem);
                }
                this.updatePropertyTable();
                this.setDirty(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeProperty() {
        if (this.m_CurrentStyle != null) {
            Map map = this.m_CurrentStyle.getStyleItemMap();
            for (PropertyNode propertyNode : this.m_StyleProperties.getSelectedProperties()) {
                map.remove(propertyNode.getName().getName());
            }
            this.updatePropertyTable();
            this.setDirty(true);
        }
    }

    public void removeAllProperties() {
        if (this.m_CurrentStyle != null) {
            this.m_CurrentStyle.getStyleItemMap().clear();
            this.updatePropertyTable();
            this.setDirty(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.m_Table.getSelectedRow();
        this.m_CurrentStyle = n >= 0 ? this.m_Styles.get(n) : null;
        this.updateButtons();
        this.updatePropertyTable();
    }

    @Override
    public boolean isDirty() {
        return this.m_IsDirty;
    }

    @Override
    public void setDirty(boolean bl) {
        this.m_IsDirty = bl;
        if (this.m_DirtyListeners != null) {
            for (IDirtyState.Listener listener : this.m_DirtyListeners) {
                listener.dirtyStateChanged(this);
            }
        }
    }

    @Override
    public void addDirtyListener(IDirtyState.Listener listener) {
        if (this.m_DirtyListeners == null) {
            this.m_DirtyListeners = new ArrayList<IDirtyState.Listener>();
        }
        this.m_DirtyListeners.add(listener);
    }

    @Override
    public void removeDirtyListener(IDirtyState.Listener listener) {
        if (this.m_DirtyListeners != null) {
            this.m_DirtyListeners.remove(listener);
        }
    }

    public void disposeEditor() {
        this.m_Table.disposeEditor();
        this.m_StyleProperties.disposeEditor();
    }

    private String getNextName() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Style style : this.m_Styles) {
            hashSet.add(style.getName());
        }
        int n = 1;
        while (hashSet.contains("Style " + n)) {
            ++n;
        }
        return "Style " + n;
    }

    private void findFreeName(Style style) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Style style2 : this.m_Styles) {
            hashSet.add(style2.getName());
        }
        String string = style.getName();
        if (hashSet.contains(string)) {
            int n = 1;
            while (hashSet.contains((String)string + " Copy " + n)) {
                ++n;
            }
            style.setName((String)string + " Copy " + n);
        }
    }

    private void updatePropertyTable() {
        this.m_StyleProperties.disposeEditor();
        ArrayList<PropertyHolder> arrayList = new ArrayList<PropertyHolder>();
        if (this.m_CurrentStyle != null) {
            arrayList.add((PropertyHolder)this.m_CurrentStyle);
        }
        this.m_StyleProperties.setPropertyHolders(arrayList);
    }

    private void updateButtons() {
        int n = this.m_Table.getSelectedRow();
        this.m_Add.setEnabled(n >= 0);
        this.m_Remove.setEnabled(n >= 0);
        this.m_RemoveAll.setEnabled(n >= 0);
    }

    private class StyleModel
    extends ElxTableModel {
        public StyleModel() {
            super(I18N.ERD, S_COLUMNS);
            this.refresh();
        }

        public void refresh() {
            StylesPanel.this.m_Styles.clear();
            Map map = StylesPanel.this.m_StyleManager.getStyleMap();
            StylesPanel.this.m_Styles.addAll(map.values());
            Collections.sort(StylesPanel.this.m_Styles);
            this.fireTableStructureChanged();
        }

        @Override
        public int getRowCount() {
            return StylesPanel.this.m_Styles.size();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0 || n == 2) {
                return String.class;
            }
            return Style.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Style style = StylesPanel.this.m_Styles.get(n);
            if (!(style instanceof Style)) {
                m_Log.error((Object)("Styles holds a " + String.valueOf(style)));
            }
            Style style2 = StylesPanel.this.m_Styles.get(n);
            if (n2 == 0) {
                return style2.getName();
            }
            return style2.getBaseName();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Style style = StylesPanel.this.m_Styles.get(n);
            if (n2 == 0) {
                String string = (String)object;
                Map map = StylesPanel.this.m_StyleManager.getStyleMap();
                Style style2 = (Style)map.get(string);
                if (style2 != null) {
                    int n3;
                    if (style2 != style && (n3 = JOptionPane.showConfirmDialog(StylesPanel.this, "A style named " + string + " already exists. Do you want to replace it?")) == 0) {
                        map.remove(string);
                        map.remove(style.getName());
                        style.setName(string);
                        StylesPanel.this.m_StyleManager.addStyle((IStyle)style);
                        this.refresh();
                    }
                } else {
                    map.remove(style.getName());
                    style.setName(object.toString());
                    StylesPanel.this.m_StyleManager.addStyle((IStyle)style);
                    this.refresh();
                }
            } else if (n2 == 1 && object != null) {
                style.setBaseName(object.toString());
            }
        }

        public Style getStyle(int n) {
            return StylesPanel.this.m_Styles.get(n);
        }

        public int indexOfStyle(Style style) {
            return StylesPanel.this.m_Styles.indexOf(style);
        }

        public void addStyle(Style style) {
            int n = StylesPanel.this.m_StyleManager.getStyleCount();
            StylesPanel.this.m_StyleManager.addStyle((IStyle)style);
            this.refresh();
            this.fireTableRowsInserted(n, n);
        }

        public void removeStyle(Style style) {
            int n = StylesPanel.this.m_Styles.indexOf(style);
            if (n >= 0) {
                StylesPanel.this.m_Styles.remove(style);
                StylesPanel.this.m_StyleManager.getStyleMap().remove(style.getName());
                this.fireTableRowsDeleted(n, n);
            }
        }

        public int moveUp(int n) {
            if (n > 0) {
                Style style = StylesPanel.this.m_Styles.remove(n);
                StylesPanel.this.m_Styles.add(n - 1, style);
                this.fireTableRowsUpdated(n - 1, n);
                return n - 1;
            }
            return n;
        }

        public int moveDown(int n) {
            if (n < StylesPanel.this.m_Styles.size() - 1) {
                Style style = StylesPanel.this.m_Styles.remove(n);
                StylesPanel.this.m_Styles.add(n + 1, style);
                this.fireTableRowsUpdated(n, n + 1);
                return n + 1;
            }
            return n;
        }
    }

    private class StyleComboRenderer
    extends BasicTableEditor
    implements ItemListener {
        private JComboBox m_Combo = new JComboBox();

        public StyleComboRenderer() {
            ComboUtil.stripComboBorder(this.m_Combo);
            this.m_Combo.setBackground(UIManager.getColor("TextField.background"));
            this.m_Combo.setFont(UIManager.getFont("TextField.font"));
            this.m_Combo.addItemListener(this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.m_Combo.setModel(new DefaultComboBoxModel<Object>(this.getChoices(n)));
            this.m_Combo.setSelectedItem(object);
            if (bl) {
                this.m_Combo.setBackground(UIManager.getColor("Table.selectionBackground"));
            } else {
                this.m_Combo.setBackground(UIManager.getColor("TextField.background"));
            }
            return this.m_Combo;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.m_Combo.setModel(new DefaultComboBoxModel<Object>(this.getChoices(n)));
            this.m_Combo.setSelectedItem(object);
            return this.m_Combo;
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_Combo.getSelectedItem();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.fireEditingStopped();
        }

        private Object[] getChoices(int n) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("");
            Style style = StylesPanel.this.m_Styles.get(n);
            for (Style objectArray2 : StylesPanel.this.m_Styles) {
                if (objectArray2 == style) continue;
                arrayList.add(objectArray2.getName());
            }
            Object[] objectArray = new Object[arrayList.size()];
            arrayList.toArray(objectArray);
            return objectArray;
        }
    }

    private class PTL
    implements PropertyTableListener {
        private PTL() {
        }

        @Override
        public void propertyChanged(Name name, List<? extends PropertyHolder> list) {
            StylesPanel.this.setDirty(true);
        }
    }
}

