/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.style;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.IDirtyState;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.repository.RepositoryConverter;
import com.elixirtech.erd.images.Icons;
import com.elixirtech.erd.reportdesigner.style.StylesPanel;
import com.elixirtech.erd.reportdesigner.style.StylesheetUtil;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.report2.raw.IStyleManager;
import com.elixirtech.report2.raw.model.Stylesheet;
import com.elixirtech.ui.ElxTabbedPane;
import com.elixirtech.v2.repository.FileObject;
import java.awt.Component;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;

public class StylesheetTab
extends ElxTabbedPane
implements IPanelView,
IDirtyState.Listener {
    private Stylesheet m_Stylesheet;
    private StylesPanel m_Panel;

    public StylesheetTab(Stylesheet stylesheet) {
        this.m_Stylesheet = stylesheet;
        IStyleManager iStyleManager = (IStyleManager)this.m_Stylesheet.getAdapter(IStyleManager.class);
        this.m_Panel = new StylesPanel(iStyleManager);
        this.m_Panel.addDirtyListener(this);
        this.setBorder(null);
        this.addTab("Styles", this.m_Panel, "style-tab.png");
    }

    @Override
    public String getName() {
        if (this.m_Stylesheet != null) {
            return this.m_Stylesheet.getFileObject().getName();
        }
        return "Stylesheet";
    }

    @Override
    public Icon getIcon() {
        return Icons.STYLESHEET;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public FileObject getFileObject() {
        return RepositoryConverter.toFO(this.m_Stylesheet.getFileObject());
    }

    @Override
    public void dirtyStateChanged(IDirtyState iDirtyState) {
        IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
        iViewModel.refreshView();
    }

    @Override
    public boolean canSave() {
        return this.m_Panel.isDirty();
    }

    @Override
    public boolean canSaveAs() {
        return true;
    }

    @Override
    public void save() throws IOException {
        this.m_Panel.disposeEditor();
        StylesheetUtil.write(RepositoryConverter.toFO(this.m_Stylesheet.getFileObject()), this.m_Stylesheet);
        this.m_Panel.setDirty(false);
    }

    @Override
    public void saveAs(FileObject fileObject) throws IOException {
        this.m_Panel.disposeEditor();
        StylesheetUtil.write(fileObject, this.m_Stylesheet);
        this.m_Panel.setDirty(false);
    }

    @Override
    public void dispose() {
        StylesheetUtil.close(this.m_Stylesheet);
        this.m_Stylesheet = null;
    }

    private void addTab(String string, Component component, String string2) {
        this.addTab(string, ERDIcons.STYLE_TAB, component);
    }
}

