/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.style;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.repository.RepositoryAttributes;
import com.elixirtech.arch.repository.RepositoryConverter;
import com.elixirtech.report2.raw.RMLSAXOut;
import com.elixirtech.report2.raw.model.Stylesheet;
import com.elixirtech.report2.raw.model.StylesheetSAX;
import com.elixirtech.v2.XMLWriter;
import com.elixirtech.v2.repository.FileObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StylesheetUtil {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(StylesheetUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stylesheet read(final FileObject fileObject) throws IOException {
        Stylesheet stylesheet = (Stylesheet)RepositoryAttributes.get(fileObject, "Stylesheet");
        if (stylesheet == null) {
            try {
                m_Log.debug((Object)("read(" + fileObject.getName() + ")"));
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                StylesheetSAX stylesheetSAX = new StylesheetSAX();
                try (InputStream inputStream = fileObject.getInputStream();){
                    sAXParser.parse(inputStream, (DefaultHandler)stylesheetSAX);
                }
                stylesheet = (Stylesheet)stylesheetSAX.getObject();
                stylesheet.setFileObject(RepositoryConverter.toFO(fileObject));
                stylesheet.loaded();
                final Stylesheet stylesheet2 = stylesheet;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RepositoryAttributes.set(fileObject, "Stylesheet", stylesheet2);
                    }
                });
            }
            catch (ParserConfigurationException parserConfigurationException) {
                m_Log.error((Object)("read: " + String.valueOf(parserConfigurationException)), (Throwable)parserConfigurationException);
                throw new IOException(parserConfigurationException.toString());
            }
            catch (SAXException sAXException) {
                m_Log.error((Object)("read: " + String.valueOf(sAXException)), (Throwable)sAXException);
                throw new IOException(sAXException.toString());
            }
        }
        return stylesheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(FileObject fileObject, Stylesheet stylesheet) throws IOException {
        m_Log.debug((Object)("write(" + fileObject.getName() + ")"));
        try (OutputStreamWriter outputStreamWriter = null;){
            outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream());
            XMLWriter xMLWriter = new XMLWriter(outputStreamWriter);
            RMLSAXOut.process((ContentHandler)xMLWriter, (Object)stylesheet, (boolean)true);
            xMLWriter.flush();
            stylesheet.setFileObject(RepositoryConverter.toFO(fileObject));
            RepositoryAttributes.set(fileObject, "Stylesheet", stylesheet);
        }
    }

    public static void close(Stylesheet stylesheet) {
        FileObject fileObject = RepositoryConverter.toFO(stylesheet.getFileObject());
        if (fileObject != null) {
            RepositoryAttributes.set(fileObject, "Stylesheet", null);
        }
    }
}

