/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.style;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.erd.reportdesigner.style.StylesheetUtil;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Stylesheet;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.util.StringUtil;
import com.elixirtech.v2.repository.FileObject;
import java.io.IOException;
import javax.swing.JTextField;

public class StylesheetWizard
extends Wizard {
    FileObject m_Parent;
    JTextField m_StylesheetName;

    public StylesheetWizard(FileObject fileObject) {
        super(I18N.ERD.getString("StylesheetWizard.title"));
        this.m_Parent = fileObject;
        this.m_Pages.add(new StylesheetPage());
    }

    @Override
    public boolean performFinish() {
        Stylesheet stylesheet = new Stylesheet();
        Object object = this.m_StylesheetName.getText().trim();
        if (!((String)object).endsWith(".rss")) {
            object = (String)object + ".rss";
        }
        try {
            FileObject fileObject = this.m_Parent.createData((String)object);
            StylesheetUtil.write(fileObject, stylesheet);
            RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
            repositoryExplorer.select(fileObject);
            return true;
        }
        catch (IOException iOException) {
            ElixirJ.error(I18N.ERD.getString("StylesheetWizard.error-saving") + (String)object + " : " + String.valueOf(iOException), iOException);
            return false;
        }
    }

    private class StylesheetPage
    extends RelativeLayoutWizardPage {
        public StylesheetPage() {
            super("Stylesheet", null);
            this.setWizard(StylesheetWizard.this);
            StylesheetWizard.this.m_StylesheetName = this.addLabelledField("name");
            StylesheetWizard.this.m_StylesheetName.getDocument().addDocumentListener(new FieldWatcher(this.m_Wizard));
            this.stickTop("name");
            this.putRight("name", "name-label", 10);
            I18N.ERD_MAP.injectComponents("StylesheetPage.", this.m_Component);
            I18N.ERD_MAP.injectObject(null, this, "StylesheetPage");
        }

        @Override
        public boolean canFlipToNextPage() {
            return false;
        }

        @Override
        public boolean isPageComplete() {
            boolean bl = true;
            this.setError(null);
            Object object = StylesheetWizard.this.m_StylesheetName.getText();
            if (StringUtil.isEmpty((String)object)) {
                this.setError(I18N.ERD.getString("StylesheetPage.name-required"));
                bl = false;
            } else {
                if (!((String)object).endsWith(".rss")) {
                    object = (String)object + ".rss";
                }
                if (StylesheetWizard.this.m_Parent.getChild((String)object) != null) {
                    this.setError(I18N.ERD.getString("StylesheetPage.name-used"));
                    bl = false;
                }
            }
            this.m_Wizard.getContainer().updateMessage();
            return bl;
        }
    }
}

