/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.tool;

import com.elixirtech.erd.reportdesigner.ComponentToolBar;
import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.tool.IBeanFactory;
import com.elixirtech.erd.reportdesigner.tool.RectangleTracker;
import com.elixirtech.erd.reportdesigner.tool.StyledTool;
import com.elixirtech.erd.reportdesigner.tool.Tool;
import com.elixirtech.report2.raw.model.RawReport;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public abstract class CreationTool
implements StyledTool {
    public static final int TOLERANCE = 60;
    protected Tool m_Tracker;
    protected IBeanFactory m_Factory;
    protected ComponentToolBar m_ToolBar;
    protected String m_Style;

    public CreationTool(IBeanFactory iBeanFactory, ComponentToolBar componentToolBar) {
        this.m_Factory = iBeanFactory;
        this.m_ToolBar = componentToolBar;
    }

    @Override
    public String getStyle() {
        return this.m_Style;
    }

    @Override
    public void setStyle(String string) {
        this.m_Style = string;
    }

    @Override
    public void mouseMoved(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        chunkPanel.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mousePressed(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        RawReport rawReport = chunkPanel.getReport();
        this.m_Tracker = new RectangleTracker(rawReport, Color.black, chunkPanel.getHRulers(), chunkPanel.getVRulers());
        this.m_Tracker.mousePressed(chunkPanel, mouseEvent);
    }

    @Override
    public void mouseDragged(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        if (this.m_Tracker != null) {
            this.m_Tracker.mouseDragged(chunkPanel, mouseEvent);
        }
    }

    @Override
    public void mouseReleased(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        if (this.m_Tracker != null) {
            this.m_Tracker.mouseReleased(chunkPanel, mouseEvent);
            this.createShape(chunkPanel, mouseEvent);
        }
    }

    protected abstract void createShape(ChunkPanel var1, MouseEvent var2);

    @Override
    public void doPopup(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(ChunkPanel chunkPanel, KeyStroke keyStroke) {
        if (this.m_Tracker != null) {
            this.m_Tracker.keyPressed(chunkPanel, keyStroke);
        }
    }

    protected boolean isShiftPressed(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 1) != 0;
    }

    protected boolean isAltPressed(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 8) != 0;
    }

    protected String dump(TreePath treePath) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < treePath.getPathCount(); ++i) {
            stringBuffer.append(String.valueOf(treePath.getPathComponent(i)) + ", ");
        }
        return stringBuffer.toString();
    }
}

