/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.tool;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.erd.reportdesigner.ComponentToolBar;
import com.elixirtech.erd.reportdesigner.chunk.ChunkManager;
import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.shape.LineShape;
import com.elixirtech.erd.reportdesigner.shape.UiModelElementShape;
import com.elixirtech.erd.reportdesigner.tool.CreationTool;
import com.elixirtech.erd.reportdesigner.tool.IBeanFactory;
import com.elixirtech.erd.reportdesigner.tool.LineTracker;
import com.elixirtech.report2.raw.model.BasicRawElementHolder;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class LineCreationTool
extends CreationTool {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(LineCreationTool.class);

    public LineCreationTool(IBeanFactory iBeanFactory, ComponentToolBar componentToolBar) {
        super(iBeanFactory, componentToolBar);
    }

    @Override
    public void mousePressed(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        this.m_Tracker = new LineTracker(Color.black, chunkPanel.getHRulers(), chunkPanel.getVRulers());
        this.m_Tracker.mousePressed(chunkPanel, mouseEvent);
    }

    @Override
    protected void createShape(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        Point[] pointArray = ((LineTracker)this.m_Tracker).getPoints();
        if (pointArray != null) {
            ChunkManager chunkManager = chunkPanel.getChunkManager();
            BasicRawElementHolder basicRawElementHolder = chunkManager.getHolderAt(pointArray[0]);
            if (basicRawElementHolder != null) {
                RawModelElement rawModelElement = this.m_Factory.createBean(chunkPanel, (IRawElementHolder)basicRawElementHolder, this.m_Style);
                if (rawModelElement != null) {
                    UiModelElementShape uiModelElementShape = this.m_Factory.createShapeFor(rawModelElement);
                    if (uiModelElementShape != null) {
                        LineShape lineShape = (LineShape)uiModelElementShape;
                        lineShape.setPoints(pointArray);
                        chunkManager.add(basicRawElementHolder, rawModelElement, this.isShiftPressed(mouseEvent));
                        rawModelElement.loaded();
                    } else {
                        m_Log.debug((Object)"shape is null: creation cancelled");
                    }
                } else {
                    m_Log.debug((Object)"obj is null");
                }
            } else {
                m_Log.debug((Object)"parent is null");
            }
        }
        if (!this.isAltPressed(mouseEvent)) {
            this.m_ToolBar.selectSelectionTool();
        }
    }
}

