/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.tool;

import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.tool.Tool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.KeyStroke;

public class LineTracker
implements Tool {
    private int[] m_HRulers;
    private int[] m_VRulers;
    private Point m_DownPt;
    private Point m_UpPt;
    private Color m_Color;
    private boolean m_Aborted;
    private static final BasicStroke SELECTION_STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{40.0f, 40.0f}, 0.0f);

    public LineTracker(Color color, int[] nArray, int[] nArray2) {
        this.m_Color = color;
        this.m_HRulers = nArray;
        this.m_VRulers = nArray2;
    }

    public Point[] getPoints() {
        if (!this.m_Aborted) {
            return new Point[]{this.m_DownPt, this.m_UpPt};
        }
        return null;
    }

    @Override
    public void mousePressed(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        this.m_Aborted = false;
        this.m_DownPt = this.m_UpPt = this.snapToRulers(mouseEvent.getPoint());
    }

    @Override
    public void mouseReleased(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        if (!this.m_Aborted) {
            this.m_UpPt = this.snapToRulers(mouseEvent.getPoint());
            chunkPanel.repaintBody();
        }
    }

    @Override
    public void mouseMoved(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        if (!this.m_Aborted) {
            Graphics2D graphics2D = chunkPanel.getBodyGraphics();
            graphics2D.setColor(this.m_Color);
            graphics2D.setStroke(SELECTION_STROKE);
            this.m_UpPt = this.snapToRulers(mouseEvent.getPoint());
            graphics2D.drawLine(this.m_DownPt.x, this.m_DownPt.y, this.m_UpPt.x, this.m_UpPt.y);
            graphics2D.dispose();
        }
    }

    @Override
    public void doPopup(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(ChunkPanel chunkPanel, KeyStroke keyStroke) {
        if (keyStroke.getKeyCode() == 27) {
            this.m_Aborted = true;
            chunkPanel.repaintBody();
        }
    }

    protected Point snapToRulers(Point point) {
        int n;
        if (this.m_HRulers != null) {
            for (n = 0; n < this.m_HRulers.length; ++n) {
                if (Math.abs(point.x - this.m_HRulers[n]) >= 80) continue;
                point.x = this.m_HRulers[n];
                break;
            }
        }
        if (this.m_VRulers != null) {
            for (n = 0; n < this.m_VRulers.length; ++n) {
                if (Math.abs(point.y - this.m_VRulers[n]) >= 80) continue;
                point.y = this.m_VRulers[n];
                break;
            }
        }
        return point;
    }
}

