/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.tool;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.erd.reportdesigner.ComponentToolBar;
import com.elixirtech.erd.reportdesigner.chunk.ChunkManager;
import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import com.elixirtech.erd.reportdesigner.shape.UiModelElementShape;
import com.elixirtech.erd.reportdesigner.tool.CreationTool;
import com.elixirtech.erd.reportdesigner.tool.IBeanFactory;
import com.elixirtech.erd.reportdesigner.tool.RectangleTracker;
import com.elixirtech.report2.raw.model.BasicRawElementHolder;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class RectCreationTool
extends CreationTool {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RectCreationTool.class);

    public RectCreationTool(IBeanFactory iBeanFactory, ComponentToolBar componentToolBar) {
        super(iBeanFactory, componentToolBar);
    }

    @Override
    public void mousePressed(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        RawReport rawReport = chunkPanel.getReport();
        this.m_Tracker = new RectangleTracker(rawReport, Color.black, chunkPanel.getHRulers(), chunkPanel.getVRulers());
        this.m_Tracker.mousePressed(chunkPanel, mouseEvent);
    }

    @Override
    protected void createShape(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        Rectangle rectangle = ((RectangleTracker)this.m_Tracker).getRectangle();
        if (rectangle != null) {
            ChunkManager chunkManager;
            BasicRawElementHolder basicRawElementHolder;
            if (rectangle.width == 0 && rectangle.height == 0) {
                rectangle.width = 2000;
                rectangle.height = 400;
            }
            if ((basicRawElementHolder = (chunkManager = chunkPanel.getChunkManager()).getHolderAt(new Point(rectangle.x, rectangle.y))) != null) {
                RawModelElement rawModelElement = this.m_Factory.createBean(chunkPanel, (IRawElementHolder)basicRawElementHolder, this.m_Style);
                if (rawModelElement != null) {
                    UiModelElementShape uiModelElementShape = this.m_Factory.createShapeFor(rawModelElement);
                    if (uiModelElementShape != null) {
                        ((AbstractShape)uiModelElementShape).setRect(rectangle);
                        chunkManager.add(basicRawElementHolder, rawModelElement, this.isShiftPressed(mouseEvent));
                        rawModelElement.loaded();
                    } else {
                        m_Log.debug((Object)"shape is null: creation cancelled");
                    }
                } else {
                    m_Log.debug((Object)"obj is null");
                }
            } else {
                m_Log.debug((Object)"parent is null");
            }
        }
        if (!this.isAltPressed(mouseEvent)) {
            this.m_ToolBar.selectSelectionTool();
        }
    }
}

