/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.tool;

import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.tool.Tool;
import com.elixirtech.report2.raw.model.RawReport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.KeyStroke;

public class RectangleTracker
implements Tool {
    private RawReport m_Report;
    private int[] m_HRulers;
    private int[] m_VRulers;
    private Point m_DownPt;
    private Rectangle m_Rect = new Rectangle();
    private Color m_Color;
    private boolean m_Aborted;
    private static final BasicStroke SELECTION_STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{40.0f, 40.0f}, 0.0f);

    public RectangleTracker(RawReport rawReport, Color color, int[] nArray, int[] nArray2) {
        this.m_Report = rawReport;
        this.m_Color = color;
        this.m_HRulers = nArray;
        this.m_VRulers = nArray2;
    }

    public Rectangle getRectangle() {
        if (!this.m_Aborted) {
            return this.m_Rect;
        }
        return null;
    }

    @Override
    public void mousePressed(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        this.m_Aborted = false;
        this.m_DownPt = this.snapToRulers(mouseEvent.getPoint());
    }

    @Override
    public void mouseReleased(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        if (!this.m_Aborted) {
            this.buildRect(this.snapToRulers(mouseEvent.getPoint()));
            chunkPanel.repaintBody();
        }
    }

    @Override
    public void mouseMoved(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        if (!this.m_Aborted) {
            Graphics2D graphics2D = chunkPanel.getBodyGraphics();
            graphics2D.setColor(this.m_Color);
            graphics2D.setStroke(SELECTION_STROKE);
            this.buildRect(this.snapToRulers(mouseEvent.getPoint()));
            graphics2D.drawRect(this.m_Rect.x, this.m_Rect.y, this.m_Rect.width, this.m_Rect.height);
            graphics2D.dispose();
        }
        chunkPanel.getSelectionManager().setCurrentRange(this.m_Rect);
    }

    @Override
    public void doPopup(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(ChunkPanel chunkPanel, KeyStroke keyStroke) {
        if (keyStroke.getKeyCode() == 27) {
            this.m_Aborted = true;
            chunkPanel.repaintBody();
        }
    }

    private void buildRect(Point point) {
        this.m_Rect.x = this.m_DownPt.x;
        this.m_Rect.y = this.m_DownPt.y;
        this.m_Rect.width = point.x - this.m_DownPt.x;
        this.m_Rect.height = point.y - this.m_DownPt.y;
        if (this.m_Rect.width < 0) {
            this.m_Rect.width = -this.m_Rect.width;
            this.m_Rect.x -= this.m_Rect.width;
        }
        if (this.m_Rect.height < 0) {
            this.m_Rect.height = -this.m_Rect.height;
            this.m_Rect.y -= this.m_Rect.height;
        }
    }

    protected Point snapToRulers(Point point) {
        int n;
        if (this.m_Report != null && this.m_Report.isGridEnabled()) {
            n = this.m_Report.getGridX();
            int n2 = this.m_Report.getGridY();
            if (n > 1) {
                point.x -= point.x % n;
            }
            if (n2 > 1) {
                point.y -= point.y % n2;
            }
        }
        if (this.m_HRulers != null) {
            for (n = 0; n < this.m_HRulers.length; ++n) {
                if (Math.abs(point.x - this.m_HRulers[n]) >= 80) continue;
                point.x = this.m_HRulers[n];
                break;
            }
        }
        if (this.m_VRulers != null) {
            for (n = 0; n < this.m_VRulers.length; ++n) {
                if (Math.abs(point.y - this.m_VRulers[n]) >= 80) continue;
                point.y = this.m_VRulers[n];
                break;
            }
        }
        return point;
    }
}

