/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.tool;

import com.elixirtech.command.Command;
import com.elixirtech.command.CommandManager;
import com.elixirtech.erd.reportdesigner.ERDAction;
import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.component.ComponentRegistry;
import com.elixirtech.erd.reportdesigner.select.SelectionManager;
import com.elixirtech.erd.reportdesigner.shape.AbstractShape;
import com.elixirtech.erd.reportdesigner.shape.GroupShape;
import com.elixirtech.erd.reportdesigner.shape.Handle;
import com.elixirtech.erd.reportdesigner.tool.CopyAction;
import com.elixirtech.erd.reportdesigner.tool.CutAction;
import com.elixirtech.erd.reportdesigner.tool.PasteAction;
import com.elixirtech.erd.reportdesigner.tool.RectangleTracker;
import com.elixirtech.erd.reportdesigner.tool.Tool;
import com.elixirtech.erd.reportdesigner.tool.UiElementBeanFactory;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.ShapeGroup;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class SelectionTool
implements Tool {
    public static final int TOLERANCE = 60;
    public static SelectionTool m_Selection;
    private Tool m_Tracker;

    public static SelectionTool current() {
        return m_Selection;
    }

    public SelectionTool() {
        m_Selection = this;
    }

    @Override
    public void mouseMoved(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        Handle handle = this.getHandle(chunkPanel, mouseEvent);
        if (handle != null) {
            chunkPanel.setCursor(handle.getCursor());
        } else {
            chunkPanel.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void mousePressed(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        this.m_Tracker = null;
        if (mouseEvent.getClickCount() == 2 && !mouseEvent.isControlDown()) {
            SelectionTool.doubleClick(chunkPanel, mouseEvent);
        }
        if (mouseEvent.getButton() == 1) {
            Handle[] handleArray = this.getHandles(chunkPanel, mouseEvent);
            if (handleArray != null) {
                this.m_Tracker = new HandleTracker(handleArray, true);
            } else {
                RawModelElement rawModelElement = this.getElement(chunkPanel, mouseEvent);
                if (rawModelElement != null) {
                    SelectionManager selectionManager = chunkPanel.getSelectionManager();
                    if (this.isShiftPressed(mouseEvent)) {
                        selectionManager.addSelection(rawModelElement);
                    } else {
                        selectionManager.setSelection(rawModelElement);
                    }
                    chunkPanel.repaintBody();
                    handleArray = this.getHandles(chunkPanel, mouseEvent);
                    if (handleArray != null) {
                        this.m_Tracker = new HandleTracker(handleArray, false);
                    }
                } else {
                    this.m_Tracker = new RectangleTracker(null, Color.blue, null, null);
                }
            }
            if (this.m_Tracker != null) {
                this.m_Tracker.mousePressed(chunkPanel, mouseEvent);
            }
        }
    }

    @Override
    public void mouseDragged(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        if (this.m_Tracker != null) {
            this.m_Tracker.mouseDragged(chunkPanel, mouseEvent);
        }
    }

    @Override
    public void mouseReleased(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        if (this.m_Tracker != null) {
            Rectangle rectangle;
            this.m_Tracker.mouseReleased(chunkPanel, mouseEvent);
            if (this.m_Tracker instanceof RectangleTracker && (rectangle = ((RectangleTracker)this.m_Tracker).getRectangle()) != null) {
                List<RawModelElement> list = this.getElements(chunkPanel, rectangle);
                if (list.size() == 0) {
                    chunkPanel.getSelectionManager().setSelection((RawModelElement)chunkPanel.getChunk());
                } else if (!this.isShiftPressed(mouseEvent)) {
                    chunkPanel.getSelectionManager().setSelection(list);
                } else {
                    chunkPanel.getSelectionManager().toggleSelection(list);
                }
            }
        }
        this.m_Tracker = null;
    }

    @Override
    public void doPopup(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        this.getPopup(chunkPanel, mouseEvent).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public JPopupMenu getPopup(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        SelectionManager selectionManager = chunkPanel.getSelectionManager();
        List<RawModelElement> list = selectionManager.getSelection();
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (list.size() > 0) {
            Object object;
            if (list.size() == 1) {
                RawModelElement rawModelElement = list.get(0);
                jPopupMenu.add(new ShowPropertiesAction(rawModelElement, chunkPanel.isReadOnly()));
                object = (AbstractShape)rawModelElement.getShape();
                if (object != null) {
                    Action[] actionArray = ((AbstractShape)object).getPopupActions(mouseEvent.getPoint());
                    for (int i = 0; i < actionArray.length; ++i) {
                        jPopupMenu.add(actionArray[i]);
                    }
                }
            }
            boolean bl = true;
            for (RawModelElement rawModelElement : list) {
                AbstractShape abstractShape = (AbstractShape)rawModelElement.getShape();
                if (abstractShape != null && abstractShape.isInteractive()) continue;
                bl = false;
            }
            if (bl) {
                jPopupMenu.add(new GroupAction(chunkPanel));
                jPopupMenu.add(new UnGroupAction(chunkPanel));
                jPopupMenu.add(new CutAction(chunkPanel));
                jPopupMenu.add(new CopyAction(chunkPanel));
                jPopupMenu.add(new PasteAction(chunkPanel));
                jPopupMenu.add(new DeleteAction(chunkPanel));
                object = new JMenu(I18N.ERD.getString("Menu.ordering"));
                ((JMenu)object).add(new BringForwardAction(chunkPanel));
                ((JMenu)object).add(new SendBackAction(chunkPanel));
                ((JMenu)object).add(new BringToFrontAction(chunkPanel));
                ((JMenu)object).add(new SendToBackAction(chunkPanel));
                jPopupMenu.add((JMenuItem)object);
            } else if (list.size() == 1 && list.get(0) instanceof Chunk) {
                jPopupMenu.add(new PasteAction(chunkPanel));
            }
        } else {
            jPopupMenu.add(new PasteAction(chunkPanel));
        }
        return jPopupMenu;
    }

    public static void doubleClick(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        SelectionManager selectionManager = chunkPanel.getSelectionManager();
        List<RawModelElement> list = selectionManager.getSelection();
        if (list.size() == 1) {
            RawModelElement rawModelElement = list.get(0);
            if (rawModelElement instanceof Chunk) {
                UiElementBeanFactory.showPropertyDialog(rawModelElement, chunkPanel.isReadOnly());
            } else {
                AbstractShape abstractShape = (AbstractShape)rawModelElement.getShape();
                if (abstractShape != null) {
                    abstractShape.doDoubleClick(mouseEvent.getPoint());
                }
            }
        }
    }

    @Override
    public void keyPressed(ChunkPanel chunkPanel, KeyStroke keyStroke) {
        if (this.m_Tracker != null) {
            this.m_Tracker.keyPressed(chunkPanel, keyStroke);
        } else {
            int n;
            RawReport rawReport = chunkPanel.getReport();
            if (rawReport.getSecurity().isReadOnly()) {
                return;
            }
            boolean bl = rawReport.isGridEnabled();
            int n2 = bl ? rawReport.getGridX() : 200;
            int n3 = n = bl ? rawReport.getGridY() : 200;
            if (this.isKeyStroke(keyStroke, 127, 0)) {
                chunkPanel.getChunkManager().delete();
            } else if (this.isKeyStroke(keyStroke, 38, 0)) {
                this.shiftY(chunkPanel, -n, true);
            } else if (this.isKeyStroke(keyStroke, 40, 0)) {
                this.shiftY(chunkPanel, n, true);
            } else if (this.isKeyStroke(keyStroke, 37, 0)) {
                this.shiftX(chunkPanel, -n2, true);
            } else if (this.isKeyStroke(keyStroke, 39, 0)) {
                this.shiftX(chunkPanel, n2, true);
            } else if (this.isKeyStroke(keyStroke, 38, 2)) {
                this.shiftY(chunkPanel, -20, false);
            } else if (this.isKeyStroke(keyStroke, 40, 2)) {
                this.shiftY(chunkPanel, 20, false);
            } else if (this.isKeyStroke(keyStroke, 37, 2)) {
                this.shiftX(chunkPanel, -20, false);
            } else if (this.isKeyStroke(keyStroke, 39, 2)) {
                this.shiftX(chunkPanel, 20, false);
            } else if (this.isKeyStroke(keyStroke, 71, 2)) {
                chunkPanel.getChunkManager().group();
            } else if (this.isKeyStroke(keyStroke, 85, 2)) {
                chunkPanel.getChunkManager().ungroup();
            } else if (this.isKeyStroke(keyStroke, 88, 2)) {
                chunkPanel.getChunkManager().cut();
            } else if (this.isKeyStroke(keyStroke, 67, 2)) {
                chunkPanel.getChunkManager().copy();
            } else if (this.isKeyStroke(keyStroke, 86, 2)) {
                chunkPanel.getChunkManager().paste();
            } else if (this.isKeyStroke(keyStroke, 9, 0)) {
                boolean bl2;
                boolean bl3 = bl2 = chunkPanel.getSelectionManager().getSelection().size() == 1;
                if (bl2) {
                    chunkPanel.getChunkManager().nextElement();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else if (this.isKeyStroke(keyStroke, 9, 1)) {
                boolean bl4;
                boolean bl5 = bl4 = chunkPanel.getSelectionManager().getSelection().size() == 1;
                if (bl4) {
                    chunkPanel.getChunkManager().previousElement();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else if (this.isKeyStroke(keyStroke, 36, 0)) {
                chunkPanel.getChunkManager().firstElement();
            } else if (this.isKeyStroke(keyStroke, 35, 0)) {
                chunkPanel.getChunkManager().lastElement();
            } else if (this.isKeyStroke(keyStroke, 10, 2)) {
                RawModelElement rawModelElement;
                boolean bl6;
                List<RawModelElement> list = chunkPanel.getSelectionManager().getSelection();
                boolean bl7 = bl6 = list.size() == 1;
                if (bl6 && ComponentRegistry.hasProperties(rawModelElement = list.get(0))) {
                    UiElementBeanFactory.showPropertyDialog(rawModelElement, false);
                    chunkPanel.focusBody();
                    return;
                }
                Toolkit.getDefaultToolkit().beep();
            } else if (this.isKeyStroke(keyStroke, 90, 2)) {
                CommandManager commandManager = chunkPanel.getCommandManager();
                if (commandManager.canUndo()) {
                    commandManager.undo();
                    chunkPanel.repaintBody();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else if (this.isKeyStroke(keyStroke, 89, 2)) {
                CommandManager commandManager = chunkPanel.getCommandManager();
                if (commandManager.canRedo()) {
                    commandManager.redo();
                    chunkPanel.repaintBody();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    protected boolean isKeyStroke(KeyStroke keyStroke, int n, int n2) {
        if (keyStroke.getKeyCode() == n) {
            if (n2 == 0) {
                return keyStroke.getModifiers() == 0;
            }
            return (keyStroke.getModifiers() | n2) != 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shiftX(ChunkPanel chunkPanel, int n, boolean bl) {
        boolean bl2 = chunkPanel.isRulersEnabled();
        chunkPanel.setRulersEnabled(bl);
        try {
            Point point = new Point();
            for (RawModelElement rawModelElement : chunkPanel.getSelectionManager().getSelection()) {
                Handle handle = SelectionTool.getMoveHandle(rawModelElement);
                if (handle == null) continue;
                handle.getPos(point);
                point.x += n;
                handle.setPos(point);
            }
            chunkPanel.repaintBody();
            chunkPanel.getReport().setDirty(true);
        }
        finally {
            chunkPanel.setRulersEnabled(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shiftY(ChunkPanel chunkPanel, int n, boolean bl) {
        boolean bl2 = chunkPanel.isRulersEnabled();
        chunkPanel.setRulersEnabled(bl);
        try {
            Point point = new Point();
            for (RawModelElement rawModelElement : chunkPanel.getSelectionManager().getSelection()) {
                Handle handle = SelectionTool.getMoveHandle(rawModelElement);
                if (handle == null) continue;
                handle.getPos(point);
                point.y += n;
                handle.setPos(point);
            }
            chunkPanel.repaintBody();
            chunkPanel.getReport().setDirty(true);
        }
        finally {
            chunkPanel.setRulersEnabled(bl2);
        }
    }

    protected static Handle getMoveHandle(RawModelElement rawModelElement) {
        AbstractShape abstractShape = (AbstractShape)rawModelElement.getShape();
        int n = abstractShape.getHandleCount();
        int n2 = n - 1;
        while (n >= 0) {
            Handle handle = abstractShape.getHandle(n2);
            if (handle.getId() == 0) {
                if (abstractShape.isHandleLocked(0)) {
                    return null;
                }
                return handle;
            }
            --n2;
        }
        return null;
    }

    protected static Point subtract(Point point, Point point2) {
        return new Point(point.x - point2.x, point.y - point2.y);
    }

    protected static int diff(Point point, Point point2) {
        int n = point.x - point2.x;
        int n2 = point.y - point2.y;
        return (int)Math.sqrt(n * n + n2 * n2);
    }

    protected static Point add(Point point, Point point2) {
        return new Point(point.x + point2.x, point.y + point2.y);
    }

    protected boolean isShiftPressed(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 1) != 0;
    }

    protected Handle getHandle(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        return chunkPanel.getSelectionManager().getHandleAt(mouseEvent.getPoint());
    }

    protected Handle[] getHandles(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        return chunkPanel.getSelectionManager().getHandlesAt(mouseEvent.getPoint());
    }

    protected RawModelElement getElement(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        if (mouseEvent.isControlDown()) {
            return chunkPanel.getChunkManager().getInnerElementAt(mouseEvent.getPoint());
        }
        if (mouseEvent.isAltDown()) {
            return chunkPanel.getChunkManager().getInnermostElementAt(mouseEvent.getPoint());
        }
        return chunkPanel.getChunkManager().getElementAt(mouseEvent.getPoint());
    }

    protected List<RawModelElement> getElements(ChunkPanel chunkPanel, Rectangle rectangle) {
        return chunkPanel.getChunkManager().getElementsIn(rectangle);
    }

    protected static List<AbstractShape> expandGroupShapes(List<AbstractShape> list) {
        ArrayList<AbstractShape> arrayList = new ArrayList<AbstractShape>();
        Iterator<AbstractShape> iterator = list.iterator();
        while (iterator.hasNext()) {
            SelectionTool.addShapes(arrayList, iterator.next());
        }
        return arrayList;
    }

    protected static void addShapes(List<AbstractShape> list, AbstractShape abstractShape) {
        if (abstractShape instanceof GroupShape) {
            GroupShape groupShape = (GroupShape)abstractShape;
            int n = groupShape.getChildCount();
            for (int i = 0; i < n; ++i) {
                SelectionTool.addShapes(list, groupShape.getChild(i));
            }
        } else {
            list.add(abstractShape);
        }
    }

    private class HandleTracker
    implements Tool {
        private Point m_DownPt;
        private Handle[] m_Handles;
        private Point[] m_HandlesPos;
        private boolean m_Drag;
        private boolean m_PreviouslySelected;

        public HandleTracker(Handle[] handleArray, boolean bl) {
            this.setupHandles(handleArray);
            this.m_PreviouslySelected = bl;
        }

        protected void setupHandles(Handle[] handleArray) {
            this.m_Handles = handleArray;
            this.m_HandlesPos = new Point[this.m_Handles.length];
            for (int i = 0; i < this.m_Handles.length; ++i) {
                this.m_HandlesPos[i] = new Point();
                this.m_Handles[i].getPos(this.m_HandlesPos[i]);
            }
        }

        @Override
        public void mouseMoved(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
            this.m_DownPt = mouseEvent.getPoint();
            this.m_Drag = false;
        }

        @Override
        public void mouseDragged(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (!this.m_Drag) {
                boolean bl = this.m_Drag = SelectionTool.diff(this.m_DownPt, point) >= 60;
            }
            if (this.m_Drag) {
                Rectangle rectangle = this.doDrag(point);
                chunkPanel.repaintBody(rectangle);
            }
        }

        @Override
        public void mouseReleased(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
            if (this.m_Drag) {
                Point point = mouseEvent.getPoint();
                this.doDrag(point);
                chunkPanel.repaintBody();
                chunkPanel.getCommandManager().doCommand(new HandleCommand(chunkPanel, this.m_DownPt, point, this.m_Handles, this.m_HandlesPos));
                chunkPanel.getReport().setDirty(true);
            } else {
                SelectionManager selectionManager = chunkPanel.getSelectionManager();
                RawModelElement rawModelElement = SelectionTool.this.getElement(chunkPanel, mouseEvent);
                if (rawModelElement != null) {
                    if (!SelectionTool.this.isShiftPressed(mouseEvent)) {
                        selectionManager.setSelection(rawModelElement);
                    } else if (this.m_PreviouslySelected) {
                        selectionManager.removeSelection(rawModelElement);
                    }
                    chunkPanel.repaintBody();
                }
            }
            this.m_Handles = null;
            this.m_DownPt = null;
        }

        @Override
        public void doPopup(ChunkPanel chunkPanel, MouseEvent mouseEvent) {
        }

        @Override
        public void keyPressed(ChunkPanel chunkPanel, KeyStroke keyStroke) {
        }

        private Rectangle doDrag(Point point) {
            Rectangle rectangle = null;
            Point point2 = new Point(point.x - this.m_DownPt.x, point.y - this.m_DownPt.y);
            for (int i = 0; i < this.m_Handles.length; ++i) {
                rectangle = this.union(rectangle, this.m_Handles[i].getBoundingBox());
                this.m_Handles[i].setPos(SelectionTool.add(this.m_HandlesPos[i], point2));
                rectangle = this.union(rectangle, this.m_Handles[i].getBoundingBox());
            }
            rectangle.x -= 20;
            rectangle.y -= 20;
            rectangle.width += 40;
            rectangle.height += 40;
            return rectangle;
        }

        private Rectangle union(Rectangle rectangle, Rectangle rectangle2) {
            if (rectangle == null) {
                return rectangle2;
            }
            return rectangle.union(rectangle2);
        }
    }

    private static class ShowPropertiesAction
    extends ERDAction {
        private final RawModelElement m_Model;
        private final boolean m_ReadOnly;

        public ShowPropertiesAction(RawModelElement rawModelElement, boolean bl) {
            super("Properties");
            this.m_Model = rawModelElement;
            this.m_ReadOnly = bl;
            boolean bl2 = ComponentRegistry.hasEditableWizard(rawModelElement);
            if (bl2) {
                this.putValue("Name", I18N.ERD.getString("WizardLauncher"));
            } else {
                this.setEnabled(ComponentRegistry.hasProperties(rawModelElement));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UiElementBeanFactory.showPropertyDialog(this.m_Model, this.m_ReadOnly);
        }
    }

    private static class GroupAction
    extends ERDAction {
        private ChunkPanel m_ChunkPanel;

        public GroupAction(ChunkPanel chunkPanel) {
            super("Group");
            this.m_ChunkPanel = chunkPanel;
            this.setEnabled(!this.m_ChunkPanel.isReadOnly() && this.m_ChunkPanel.getSelectionManager().getSelection().size() > 1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.m_ChunkPanel.getChunkManager().group();
        }
    }

    private static class UnGroupAction
    extends ERDAction {
        private ChunkPanel m_ChunkPanel;

        public UnGroupAction(ChunkPanel chunkPanel) {
            super("UnGroup");
            this.m_ChunkPanel = chunkPanel;
            this.setEnabled(false);
            if (!this.m_ChunkPanel.isReadOnly()) {
                List<RawModelElement> list = this.m_ChunkPanel.getSelectionManager().getSelection();
                for (RawModelElement rawModelElement : list) {
                    if (!(rawModelElement instanceof ShapeGroup)) continue;
                    this.setEnabled(true);
                    break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.m_ChunkPanel.getChunkManager().ungroup();
        }
    }

    private static class DeleteAction
    extends ERDAction {
        private ChunkPanel m_ChunkPanel;

        public DeleteAction(ChunkPanel chunkPanel) {
            super("Delete.Tip");
            this.m_ChunkPanel = chunkPanel;
            this.setEnabled(!this.m_ChunkPanel.isReadOnly());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.m_ChunkPanel.getChunkManager().delete();
        }
    }

    private static class BringForwardAction
    extends ERDAction {
        private ChunkPanel m_ChunkPanel;

        public BringForwardAction(ChunkPanel chunkPanel) {
            super("BringForward");
            this.m_ChunkPanel = chunkPanel;
            this.setEnabled(!this.m_ChunkPanel.isReadOnly());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.m_ChunkPanel.getChunkManager().bringForward();
        }
    }

    private static class SendBackAction
    extends ERDAction {
        private ChunkPanel m_ChunkPanel;

        public SendBackAction(ChunkPanel chunkPanel) {
            super("SendBackward");
            this.m_ChunkPanel = chunkPanel;
            this.setEnabled(!this.m_ChunkPanel.isReadOnly());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.m_ChunkPanel.getChunkManager().sendBack();
        }
    }

    private static class BringToFrontAction
    extends ERDAction {
        private ChunkPanel m_ChunkPanel;

        public BringToFrontAction(ChunkPanel chunkPanel) {
            super("BringToFront");
            this.m_ChunkPanel = chunkPanel;
            this.setEnabled(!this.m_ChunkPanel.isReadOnly());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.m_ChunkPanel.getChunkManager().bringToFront();
        }
    }

    private static class SendToBackAction
    extends ERDAction {
        private ChunkPanel m_ChunkPanel;

        public SendToBackAction(ChunkPanel chunkPanel) {
            super("SendToBack");
            this.m_ChunkPanel = chunkPanel;
            this.setEnabled(!this.m_ChunkPanel.isReadOnly());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.m_ChunkPanel.getChunkManager().sendToBack();
        }
    }

    private class HandleCommand
    implements Command {
        private ChunkPanel m_ChunkPanel;
        private Point m_DownPt;
        private Point m_UpPt;
        private Handle[] m_Handles;
        private Point[] m_HandlesPos;

        public HandleCommand(ChunkPanel chunkPanel, Point point, Point point2, Handle[] handleArray, Point[] pointArray) {
            this.m_ChunkPanel = chunkPanel;
            this.m_DownPt = point;
            this.m_UpPt = point2;
            this.m_Handles = handleArray;
            this.m_HandlesPos = pointArray;
        }

        @Override
        public void doIt() {
        }

        @Override
        public void undoIt() {
            for (int i = 0; i < this.m_Handles.length; ++i) {
                this.m_Handles[i].setPos(this.m_HandlesPos[i]);
            }
            this.m_ChunkPanel.repaintBody();
        }

        @Override
        public void redoIt() {
            Point point = new Point(this.m_UpPt.x - this.m_DownPt.x, this.m_UpPt.y - this.m_DownPt.y);
            for (int i = 0; i < this.m_Handles.length; ++i) {
                this.m_Handles[i].setPos(SelectionTool.add(this.m_HandlesPos[i], point));
            }
            this.m_ChunkPanel.repaintBody();
        }
    }
}

