/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.tool;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.erd.reportdesigner.ReportTab;
import com.elixirtech.erd.reportdesigner.chunk.ChunkPanel;
import com.elixirtech.erd.reportdesigner.chunk.UiFactory;
import com.elixirtech.erd.reportdesigner.component.ComponentRegistry;
import com.elixirtech.erd.reportdesigner.shape.UiModelElementShape;
import com.elixirtech.erd.reportdesigner.tool.IBeanFactory;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.ui.ITabComponent;
import com.elixirtech.ui.property.IApplyRepainter;
import com.elixirtech.ui.property.PropertyDialog;
import com.elixirtech.ui.wizard.ISelectablePropertyWizard;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.Dimension;
import java.util.ArrayList;

public class UiElementBeanFactory
implements IBeanFactory {
    private Class<? extends RawModelElement> m_Class;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(UiElementBeanFactory.class);

    public UiElementBeanFactory(Class<? extends RawModelElement> clazz) {
        this.m_Class = clazz;
    }

    @Override
    public RawModelElement createBean(ChunkPanel chunkPanel, IRawElementHolder iRawElementHolder, String string) {
        try {
            RawModelElement rawModelElement = this.m_Class.newInstance();
            rawModelElement.setParent(iRawElementHolder);
            rawModelElement.setStyleName(string);
            return rawModelElement;
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't create a " + this.m_Class.getName()));
            return null;
        }
    }

    @Override
    public UiModelElementShape createShapeFor(RawModelElement rawModelElement) {
        if (!UiElementBeanFactory.showWizard(rawModelElement, false)) {
            return null;
        }
        return UiFactory.current().buildShape(rawModelElement);
    }

    public static boolean showWizard(RawModelElement rawModelElement, boolean bl) {
        return UiElementBeanFactory.showWizard(rawModelElement, null, bl);
    }

    public static boolean showWizard(RawModelElement rawModelElement, String string, boolean bl) {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        elixirFrame.setWaitCursor();
        IWizard iWizard = ComponentRegistry.getWizard(rawModelElement, bl);
        elixirFrame.setArrowCursor();
        if (iWizard != null) {
            if (string != null && iWizard instanceof ISelectablePropertyWizard) {
                ((ISelectablePropertyWizard)iWizard).selectProperty(string);
            }
            elixirFrame.showWizard(iWizard);
            return iWizard.isFinished();
        }
        return true;
    }

    public static boolean showPropertyDialog(RawModelElement rawModelElement, boolean bl) {
        return UiElementBeanFactory.showPropertyDialog(rawModelElement, null, bl);
    }

    public static boolean showPropertyDialog(RawModelElement rawModelElement, String string, boolean bl) {
        IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
        ReportTab reportTab = (ReportTab)iViewModel.getCurrentView();
        if (ComponentRegistry.hasEditableWizard(rawModelElement)) {
            boolean bl2 = UiElementBeanFactory.showWizard(rawModelElement, string, bl);
            if (bl2) {
                reportTab.getReport().setDirty(true);
            }
            return bl2;
        }
        ArrayList<ITabComponent> arrayList = new ArrayList<ITabComponent>();
        ComponentRegistry.addTabs(rawModelElement, arrayList);
        if (arrayList.size() > 0) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            PropertyDialog propertyDialog = new PropertyDialog(elixirFrame.getFrame(), bl, I18N.ERD.getString("PropertyDialog.title"), (IApplyRepainter)((Object)elixirFrame));
            for (ITabComponent iTabComponent : arrayList) {
                propertyDialog.addTab(iTabComponent);
            }
            if (string != null) {
                propertyDialog.selectProperty(string);
            }
            propertyDialog.pack();
            Dimension dimension = propertyDialog.getSize();
            dimension.width = 500;
            dimension.height = Math.max(400, dimension.height);
            dimension.height = Math.min(600, dimension.height);
            propertyDialog.setSize(dimension);
            propertyDialog.setLocationRelativeTo(elixirFrame.getFrame());
            elixirFrame.showModal(propertyDialog);
            boolean bl3 = propertyDialog.isFinished();
            if (bl3) {
                reportTab.getReport().setDirty(true);
            }
            return bl3;
        }
        return false;
    }
}

