/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.tool.select;

import com.elixirtech.erd.reportdesigner.tool.select.AbstractShapeAction;
import com.elixirtech.erd.reportdesigner.tool.select.CPSelection;
import com.elixirtech.icons.ERDIcons;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.util.SortUtil;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.List;

class AlignRightAction
extends AbstractShapeAction {
    public AlignRightAction(CPSelection cPSelection) {
        super("Align.Right", ERDIcons.ALIGN_RIGHT, cPSelection);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.newXYCommands();
        int n = 0;
        List<RawModelElement> list = this.m_CPSelection.m_Selection;
        for (RawModelElement rawModelElement : list) {
            n = Math.max(n, rawModelElement.getLeft() + rawModelElement.getWidth());
        }
        Object[] objectArray = list.toArray(new RawModelElement[list.size()]);
        SortUtil.sort(objectArray, this);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            int n2 = n;
            if (i > 0) {
                Rectangle rectangle = this.getBounds((RawModelElement)object);
                int n3 = n;
                for (int j = 0; j < objectArray.length; ++j) {
                    Rectangle rectangle2 = this.getBounds((RawModelElement)objectArray[j]);
                    rectangle.setLocation(n3 - rectangle.width, rectangle.y);
                    if (objectArray[j] == object || !rectangle2.intersects(rectangle)) continue;
                    n3 = rectangle2.x;
                }
                n2 = n3 - rectangle.width;
                object.setLeft(n2);
                continue;
            }
            object.setLeft(n2 - object.getWidth());
        }
        this.addCommands();
        this.repaint();
    }

    @Override
    public boolean lessThan(Object object, Object object2) {
        return ((RawModelElement)object).getLeft() > ((RawModelElement)object2).getLeft();
    }
}

