/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.reportdesigner.tool.select;

import com.elixirtech.command.Command;
import com.elixirtech.erd.reportdesigner.tool.select.CPSelection;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import java.awt.Point;
import java.util.Iterator;

class SetMoveCommand
implements Command {
    protected CPSelection m_CPSelection;
    protected int[] m_OldPointsLeft;
    protected int[] m_OldPointsTop;
    protected int[] m_NewPointsLeft;
    protected int[] m_NewPointsTop;

    public SetMoveCommand(CPSelection cPSelection) {
        this.m_CPSelection = cPSelection;
        this.updatePoints(true);
    }

    public void updatePoints(boolean bl) {
        int n = this.m_CPSelection.m_Selection.size();
        if (bl) {
            this.m_OldPointsLeft = new int[n];
            this.m_OldPointsTop = new int[n];
            this.updatePoints(this.m_OldPointsLeft, this.m_OldPointsTop);
        } else {
            this.m_NewPointsLeft = new int[n];
            this.m_NewPointsTop = new int[n];
            this.updatePoints(this.m_NewPointsLeft, this.m_NewPointsTop);
        }
        this.m_CPSelection.m_CPanel.repaintBody();
    }

    public void updatePoints(int[] nArray, int[] nArray2) {
        int n = 0;
        for (RawModelElement rawModelElement : this.m_CPSelection.m_Selection) {
            nArray[n] = rawModelElement.getLeft();
            nArray2[n++] = rawModelElement.getTop();
        }
    }

    @Override
    public void doIt() {
        int n = 0;
        for (RawModelElement rawModelElement : this.m_CPSelection.m_Selection) {
            int n2 = this.m_OldPointsLeft[n] - this.m_NewPointsLeft[n];
            int n3 = this.m_OldPointsTop[n] - this.m_NewPointsTop[n];
            if (rawModelElement instanceof IRawElementHolder) {
                this.shift(new Point(n2, n3), (IRawElementHolder)rawModelElement);
            }
            ++n;
        }
    }

    @Override
    public void undoIt() {
        this.setPoints(this.m_OldPointsLeft, this.m_OldPointsTop);
        int n = 0;
        for (RawModelElement rawModelElement : this.m_CPSelection.m_Selection) {
            int n2 = this.m_NewPointsLeft[n] - this.m_OldPointsLeft[n];
            int n3 = this.m_NewPointsTop[n] - this.m_OldPointsTop[n];
            if (rawModelElement instanceof IRawElementHolder) {
                this.shift(new Point(n2, n3), (IRawElementHolder)rawModelElement);
            }
            ++n;
        }
    }

    @Override
    public void redoIt() {
        this.setPoints(this.m_NewPointsLeft, this.m_NewPointsTop);
        this.doIt();
    }

    public void setPoints(int[] nArray, int[] nArray2) {
        int n = 0;
        for (RawModelElement rawModelElement : this.m_CPSelection.m_Selection) {
            rawModelElement.setLeft(nArray[n]);
            rawModelElement.setTop(nArray2[n]);
            ++n;
        }
    }

    private void shift(Point point, IRawElementHolder iRawElementHolder) {
        Iterator iterator = iRawElementHolder.getRawElementIterator();
        while (iterator.hasNext()) {
            RawModelElement rawModelElement = (RawModelElement)iterator.next();
            rawModelElement.setLeft(rawModelElement.getLeft() - point.x);
            rawModelElement.setTop(rawModelElement.getTop() - point.y);
            if (!(rawModelElement instanceof IRawElementHolder)) continue;
            this.shift(point, (IRawElementHolder)rawModelElement);
        }
    }
}

