/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.util;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.erd.reportdesigner.sax.ERDSAXOut;
import com.elixirtech.report2.raw.model.Holder;
import com.elixirtech.report2.raw.model.HolderSAX;
import com.elixirtech.v2.XMLWriter;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class ClipboardUtil {
    private static Owner m_Owner = new Owner();
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ClipboardUtil.class);
    static final DataFlavor[] FLAVORS = new DataFlavor[]{DataFlavor.stringFlavor};

    public static void setText(String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = ClipboardUtil.getTransferable(string);
        clipboard.setContents(transferable, m_Owner);
    }

    public static String getText() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        try {
            return (String)transferable.getTransferData(FLAVORS[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setHolder(Holder holder) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = ClipboardUtil.getTransferable(holder);
        clipboard.setContents(transferable, m_Owner);
    }

    public static Holder getHolder() {
        return ClipboardUtil.getHolder(true);
    }

    public static Holder getHolder(boolean bl) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            return ClipboardUtil.getHolder(clipboard.getContents(null), bl);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return null;
        }
        catch (IOException iOException) {
            m_Log.error((Object)"Error reading clipboard", (Throwable)iOException);
            return null;
        }
    }

    protected static Transferable getTransferable(String string) {
        return new StringSelection(string);
    }

    protected static Transferable getTransferable(Holder holder) {
        return new TransferableHolder(holder);
    }

    protected static Holder getHolder(Transferable transferable, boolean bl) throws IOException, UnsupportedFlavorException {
        Holder holder = null;
        if (transferable.isDataFlavorSupported(FLAVORS[0])) {
            try {
                String string = (String)transferable.getTransferData(FLAVORS[0]);
                StringReader stringReader = new StringReader(string);
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                HolderSAX holderSAX = new HolderSAX();
                sAXParser.parse(new InputSource(stringReader), (DefaultHandler)holderSAX);
                holder = (Holder)holderSAX.getObject();
                if (bl) {
                    holder.loaded();
                }
            }
            catch (Exception exception) {
                m_Log.error((Object)"Error parsing clipboard data", (Throwable)exception);
            }
        }
        if (holder == null) {
            holder = new Holder();
        }
        return holder;
    }

    private static class Owner
    implements ClipboardOwner {
        private Owner() {
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    public static class TransferableHolder
    implements Transferable {
        private Holder m_Holder;

        public TransferableHolder(Holder holder) {
            this.m_Holder = holder;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (dataFlavor.equals(FLAVORS[0])) {
                try {
                    StringWriter stringWriter = new StringWriter();
                    XMLWriter xMLWriter = new XMLWriter(stringWriter);
                    xMLWriter.setOutput(stringWriter);
                    new ERDSAXOut(xMLWriter, this.m_Holder, true);
                    xMLWriter.flush();
                    return stringWriter.toString();
                }
                catch (IOException iOException) {
                    m_Log.error((Object)"Can't write to clipboard", (Throwable)iOException);
                    return null;
                }
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (int i = 0; i < FLAVORS.length; ++i) {
                if (!dataFlavor.equals(FLAVORS[i])) continue;
                return true;
            }
            return false;
        }
    }
}

