/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.util;

import com.elixirtech.sax.ChangeListener;
import com.elixirtech.sax.ChangeNotifier;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DerivedComboBoxModel<T>
implements ComboBoxModel<Object>,
ChangeListener {
    private List<ListDataListener> m_Listeners = new ArrayList<ListDataListener>();
    private ChangeNotifier m_Notifier;
    private List<T> m_Source;
    private String m_Property;
    private Object m_SelectedItem;

    public DerivedComboBoxModel(ChangeNotifier changeNotifier, List<T> list, String string) {
        this.m_Notifier = changeNotifier;
        this.m_Source = list;
        this.m_Property = string;
        this.m_Notifier.addChangeListener((ChangeListener)this);
        this.refresh();
    }

    public void dispose() {
        this.m_Notifier.removeChangeListener((ChangeListener)this);
    }

    public void beanChanged(ChangeNotifier changeNotifier, String string) {
        if (this.m_Property.equals(string)) {
            this.refresh();
        }
    }

    private void refresh() {
        if (!this.m_Source.contains(this.m_SelectedItem)) {
            this.m_SelectedItem = null;
        }
        this.fireContentsChanged();
    }

    public void fireContentsChanged() {
        ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, 0);
        for (ListDataListener listDataListener : this.m_Listeners) {
            listDataListener.contentsChanged(listDataEvent);
        }
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.m_Listeners.add(listDataListener);
    }

    @Override
    public Object getElementAt(int n) {
        return this.m_Source.get(n);
    }

    @Override
    public Object getSelectedItem() {
        return this.m_SelectedItem;
    }

    @Override
    public int getSize() {
        return this.m_Source.size();
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.m_Listeners.remove(listDataListener);
    }

    @Override
    public void setSelectedItem(Object object) {
        this.m_SelectedItem = object;
    }

    public void add(T t) {
        this.m_Source.add(t);
    }

    public void remove(T t) {
        this.m_Source.remove(t);
    }

    public void add(int n, T t) {
        this.m_Source.add(n, t);
    }

    public void remove(int n) {
        this.m_Source.remove(n);
    }

    public int indexOf(T t) {
        return this.m_Source.indexOf(t);
    }
}

