/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.util;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.IMasterPropertyList;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyType;
import com.elixirtech.sax.ChangeListener;
import com.elixirtech.sax.ChangeNotifier;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class DerivedTableModel
extends AbstractTableModel
implements ChangeListener {
    public static final int COL_UNIQUE = 1;
    public static final int COL_NOT_EMPTY = 2;
    private ChangeNotifier m_Notifier;
    private List m_Source;
    private String m_Property;
    private Column[] m_Columns;
    private boolean m_IsEditable;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DerivedTableModel.class);

    public DerivedTableModel(ChangeNotifier changeNotifier, List list, String string, Column[] columnArray) {
        this.m_Notifier = changeNotifier;
        this.m_Source = list;
        this.m_Property = string;
        this.m_Columns = columnArray;
        this.m_Notifier.addChangeListener((ChangeListener)this);
        this.refresh();
    }

    public void setEditable(boolean bl) {
        this.m_IsEditable = bl;
    }

    public void dispose() {
        this.m_Notifier.removeChangeListener((ChangeListener)this);
    }

    public void beanChanged(ChangeNotifier changeNotifier, String string) {
        if (this.m_Property.equals(string)) {
            this.refresh();
        }
    }

    private void refresh() {
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.m_Source.size();
    }

    @Override
    public int getColumnCount() {
        return this.m_Columns.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.m_Columns[n].getPropertyName().getLabel();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        IMasterPropertyList iMasterPropertyList = (IMasterPropertyList)Elixir.get(IMasterPropertyList.class);
        PropertyType propertyType = iMasterPropertyList.getPropertyType(this.m_Columns[n].getPropertyName());
        if (propertyType != null) {
            return propertyType.getTypeClass();
        }
        m_Log.warn((Object)("No type defined for property " + String.valueOf(this.m_Columns[n].getPropertyName())));
        if (this.m_Source.size() > 0) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return object.getClass();
            }
            return String.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PropertyImplementor propertyImplementor = (PropertyImplementor)this.m_Source.get(n);
        return this.m_Columns[n2].getValue(propertyImplementor);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.m_Columns[n2].notEmpty() && String.valueOf(object).trim().length() == 0) {
            String string = this.m_Columns[n2].getPropertyName().getLabel();
            ElixirJ.error(string + " must contain a non-whitespace character");
            return;
        }
        if (this.checkUnique(object, n, n2)) {
            PropertyImplementor propertyImplementor = (PropertyImplementor)this.m_Source.get(n);
            this.m_Columns[n2].setValue(propertyImplementor, object);
        } else {
            String string = this.m_Columns[n2].getPropertyName().getLabel();
            ElixirJ.error(string + " '" + String.valueOf(object) + "' must be unique in this table");
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.m_IsEditable) {
            return true;
        }
        return this.m_Columns[n2].isEditable();
    }

    public void add(Object object) {
        this.m_Source.add(object);
    }

    public void remove(Object object) {
        this.m_Source.remove(object);
    }

    public void add(int n, Object object) {
        this.m_Source.add(n, object);
    }

    public void remove(int n) {
        this.m_Source.remove(n);
    }

    public int indexOf(Object object) {
        return this.m_Source.indexOf(object);
    }

    public int moveUp(int n) {
        if (n > 0) {
            Object e = this.m_Source.remove(n);
            this.m_Source.add(n - 1, e);
            this.fireTableRowsUpdated(n - 1, n);
            return n - 1;
        }
        return n;
    }

    public int moveDown(int n) {
        if (n < this.m_Source.size() - 1) {
            Object e = this.m_Source.remove(n);
            this.m_Source.add(n + 1, e);
            this.fireTableRowsUpdated(n, n + 1);
            return n + 1;
        }
        return n;
    }

    protected boolean checkUnique(Object object, int n, int n2) {
        if (this.m_Columns[n2].isUnique()) {
            int n3 = this.m_Source.size();
            for (int i = 0; i < n3; ++i) {
                Object object2;
                if (i == n || (object2 = this.getValueAt(i, n2)) == null || !object2.equals(object)) continue;
                return false;
            }
        }
        return true;
    }

    public static class Column {
        protected final Name m_PropertyName;
        protected final int m_Flags;
        protected final boolean m_Editable;

        public Column(Name name) {
            this(name, 0);
        }

        public Column(Name name, int n) {
            this(name, n, false);
        }

        public Column(Name name, int n, boolean bl) {
            this.m_PropertyName = name;
            this.m_Flags = n;
            this.m_Editable = bl;
        }

        public Name getPropertyName() {
            return this.m_PropertyName;
        }

        public boolean isUnique() {
            return (this.m_Flags & 1) != 0;
        }

        public boolean notEmpty() {
            return (this.m_Flags & 2) != 0;
        }

        public Object getValue(PropertyImplementor propertyImplementor) {
            Property property = propertyImplementor.getProperty(this.m_PropertyName);
            return property.getValue();
        }

        public void setValue(PropertyImplementor propertyImplementor, Object object) {
            Property property = propertyImplementor.getProperty(this.m_PropertyName);
            property.setValue(object);
        }

        public boolean isEditable() {
            return this.m_Editable;
        }
    }

    public static class NotifierColumn
    extends Column {
        protected VetoableChangeListener m_VetoListener;
        protected PropertyChangeListener m_Listener;

        public NotifierColumn(Name name) {
            super(name, 0, true);
        }

        public NotifierColumn(Name name, int n) {
            super(name, n, true);
        }

        public NotifierColumn(Name name, int n, VetoableChangeListener vetoableChangeListener) {
            this(name, n, vetoableChangeListener, null);
        }

        public NotifierColumn(Name name, int n, PropertyChangeListener propertyChangeListener) {
            this(name, n, null, propertyChangeListener);
        }

        public NotifierColumn(Name name, int n, VetoableChangeListener vetoableChangeListener, PropertyChangeListener propertyChangeListener) {
            super(name, n, true);
            this.addVetoableChangeListener(vetoableChangeListener);
            this.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void setValue(PropertyImplementor propertyImplementor, Object object) {
            Property property = propertyImplementor.getProperty(this.m_PropertyName);
            Object object2 = property.getValue();
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, this.m_PropertyName.getName(), object2, object);
            try {
                if (this.m_VetoListener != null) {
                    this.m_VetoListener.vetoableChange(propertyChangeEvent);
                }
                property.setValue(object);
                if (this.m_Listener != null) {
                    this.m_Listener.propertyChange(propertyChangeEvent);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                ElixirJ.error(this.getPropertyName().getLabel() + " '" + String.valueOf(object) + "' : " + propertyVetoException.getLocalizedMessage());
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.m_Listener != null) {
                throw new IllegalStateException("Only a single listener supported");
            }
            this.m_Listener = propertyChangeListener;
        }

        public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
            if (this.m_VetoListener != null) {
                throw new IllegalStateException("Only a single veto listener supported");
            }
            this.m_VetoListener = vetoableChangeListener;
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.m_Listener == propertyChangeListener) {
                this.m_Listener = null;
            }
        }

        public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
            if (this.m_VetoListener == vetoableChangeListener) {
                this.m_Listener = null;
            }
        }
    }
}

