/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.util;

import com.elixirtech.erd.util.Locator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileLocator
extends Locator {
    private final File m_File;

    public FileLocator(String string) {
        this.m_File = new File(string);
    }

    public FileLocator(File file) {
        this.m_File = file;
    }

    public FileLocator(FileLocator fileLocator, String string) {
        File file = new File(string);
        this.m_File = file.isAbsolute() ? file : new File(fileLocator.m_File, string);
    }

    public int compareTo(Object object) {
        if (object instanceof FileLocator) {
            return this.m_File.compareTo(((FileLocator)object).m_File);
        }
        return this.toString().compareTo(String.valueOf(object));
    }

    @Override
    public Locator getParent() {
        return new FileLocator(this.m_File.getParentFile());
    }

    @Override
    public Locator relativeTo(Locator locator) {
        FileLocator fileLocator = (FileLocator)locator;
        String string = fileLocator.m_File.getAbsolutePath();
        String string2 = this.m_File.getAbsolutePath();
        if (string2.startsWith(string)) {
            String string3 = string2.substring(string.length());
            if (string3.startsWith(File.separator)) {
                string3 = string3.substring(1);
            }
            return new FileLocator(string3);
        }
        return this;
    }

    public String toString() {
        return this.m_File.getAbsolutePath();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.m_File);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.m_File);
    }
}

