/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.erd.util;

import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.Style;
import java.util.HashSet;
import java.util.Set;

public class ReportUtil {
    public static String getNextDataSourceName(RawReport rawReport) {
        HashSet<String> hashSet = new HashSet<String>();
        for (DataSource dataSource : rawReport.getDataSourceList()) {
            hashSet.add(dataSource.getName());
        }
        return ReportUtil.getName(hashSet, "DataSource ");
    }

    public static String getNextPageSetupName(RawReport rawReport) {
        HashSet<String> hashSet = new HashSet<String>();
        for (PageSetup pageSetup : rawReport.getPageSetupList()) {
            hashSet.add(pageSetup.getName());
        }
        return ReportUtil.getName(hashSet, "PageSetup ");
    }

    public static String getNextSectionName(RawReport rawReport) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Section section : rawReport.getSectionList()) {
            hashSet.add(section.getName());
        }
        int n = 1;
        while (hashSet.contains("Section " + n)) {
            ++n;
        }
        return ReportUtil.getName(hashSet, "Section ");
    }

    public static String getNextStyleName(RawReport rawReport) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Style style : rawReport.getStyleMap().values()) {
            hashSet.add(style.getName());
        }
        return ReportUtil.getName(hashSet, "Style ");
    }

    public static String getName(Set<String> set, String string) {
        int n = 1;
        while (set.contains(string + n)) {
            ++n;
        }
        return string + n;
    }
}

