/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint;

import com.elixirtech.glint.EyeConstants;
import com.elixirtech.glint.EyeReader;
import com.elixirtech.glint.GlintException;
import com.elixirtech.glint.GlintInput;
import com.elixirtech.glint.GraphicsCodes;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.TOC;
import com.elixirtech.glint.TickReader;
import com.elixirtech.glint.g.GlintGraphics;
import com.elixirtech.glint.g2d.GLListener;
import com.elixirtech.glint.g2d.GlintGraphics2D;
import com.elixirtech.glint.xml.GlintOutputXML;
import com.elixirtech.ui.INavigation;
import com.elixirtech.ui.JNavigationPanel;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.util.base64.Base64Decoder;
import com.elixirtech.v2.XMLWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Stack;
import java.util.zip.GZIPInputStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.xml.sax.ContentHandler;

public class Viewer
implements HyperlinkListener {
    private JFrame m_Frame;
    private JCheckBox m_G2D;
    private JComboBox m_ZoomLevels;
    private JSplitPane m_SplitPane;
    private JTree m_Bookmarks;
    private Canvas m_Canvas;
    private byte[] m_Bytes;
    private EyeReader m_EyeReader;
    private GLListener m_GLListener;
    private JNavigationPanel m_NavPanel;
    private Stack<Integer> m_PageStack = new Stack();
    private File m_File;

    public static void main(String[] stringArray) throws Exception {
        Viewer viewer = new Viewer();
        viewer.getFrame().setDefaultCloseOperation(3);
    }

    public Viewer() throws IOException {
        this.m_Frame = new JFrame("Glint Viewer");
        this.m_Canvas = new Canvas();
        Container container = this.m_Frame.getContentPane();
        JPanel jPanel = new JPanel();
        this.m_G2D = new JCheckBox("Graphics2D");
        this.m_G2D.setSelected(true);
        jPanel.add(this.m_G2D);
        this.m_G2D.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Viewer.this.m_Canvas.repaint();
            }
        });
        JButton jButton = new JButton("Dump XML");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Viewer.this.m_File != null) {
                    try {
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(Viewer.this.m_File.getAbsolutePath() + ".dump.xml"), "UTF-8");
                        XMLWriter xMLWriter = new XMLWriter(outputStreamWriter);
                        GlintOutputXML glintOutputXML = new GlintOutputXML((ContentHandler)xMLWriter);
                        Viewer.this.m_Canvas.render((IGlint)glintOutputXML);
                        glintOutputXML.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(Viewer.this.m_Frame, exception.toString(), "Dump XML", 2);
                    }
                } else {
                    JOptionPane.showMessageDialog(Viewer.this.m_Frame, "No file loaded", "Dump XML", 2);
                }
            }
        });
        JButton jButton2 = new JButton("Previous");
        jPanel.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Viewer.this.m_PageStack.size() > 0) {
                    System.out.println("Pop");
                    int n = Viewer.this.m_PageStack.pop();
                    ((Navigator)Viewer.this.m_NavPanel.getNavigation()).gotoPage(n);
                }
            }
        });
        this.m_ZoomLevels = new JComboBox<Zoom>(Zoom.LEVELS);
        this.m_ZoomLevels.setSelectedIndex(2);
        this.m_ZoomLevels.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Viewer.this.m_Canvas.invalidate();
                Viewer.this.m_Frame.validate();
                Viewer.this.m_Canvas.repaint();
            }
        });
        jPanel.add(this.m_ZoomLevels);
        this.m_NavPanel = new JNavigationPanel(new Navigator());
        jPanel.add(this.m_NavPanel);
        container.add((Component)jPanel, "North");
        this.m_Bookmarks = new JTree((TreeModel)null);
        this.m_Bookmarks.addTreeSelectionListener(new BookmarkListener());
        this.m_SplitPane = new JSplitPane(1, new JScrollPane(this.m_Bookmarks), new JScrollPane(this.m_Canvas));
        container.add((Component)this.m_SplitPane, "Center");
        SwingUtil.setupDropTarget(this.m_Frame, new Drop());
        this.m_GLListener = new GLListener();
        this.m_Canvas.addMouseListener((MouseListener)this.m_GLListener);
        this.m_Canvas.addMouseMotionListener((MouseMotionListener)this.m_GLListener);
        this.m_GLListener.addHyperlinkListener((HyperlinkListener)this);
        this.m_Frame.pack();
        this.m_Frame.setVisible(true);
    }

    public JFrame getFrame() {
        return this.m_Frame;
    }

    public void loadFile(File file) {
        this.m_Frame.setTitle("Glint Viewer");
        this.m_File = file;
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = this.getInput(file);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.m_Bytes = byteArrayOutputStream.toByteArray();
            if (Viewer.startsWith(this.m_Bytes, GraphicsCodes.BASE64.bytes())) {
                String string = new String(this.m_Bytes);
                string = string.substring(GraphicsCodes.BASE64.length()).trim();
                this.m_Bytes = Base64Decoder.decode(string);
            }
            if (Viewer.startsWith(this.m_Bytes, EyeConstants.MARKER.bytes())) {
                this.m_EyeReader = new EyeReader((InputStream)new ByteArrayInputStream(this.m_Bytes));
                ((Navigator)this.m_NavPanel.getNavigation()).setPageCount(this.m_EyeReader.getPageCount());
                this.m_Bookmarks.setModel(TickReader.buildTreeModel((TOC)this.m_EyeReader.getTick()));
                this.m_NavPanel.refresh();
                this.m_NavPanel.setStatus();
                this.m_Frame.setTitle("Glint Viewer: " + this.m_EyeReader.getName());
            } else if (Viewer.startsWith(this.m_Bytes, GraphicsCodes.MARKER.bytes())) {
                this.m_EyeReader = null;
                ((Navigator)this.m_NavPanel.getNavigation()).setPageCount(0);
                this.m_Bookmarks.setModel(null);
                this.m_NavPanel.refresh();
                this.m_NavPanel.setStatus();
            } else {
                this.m_Bytes = null;
            }
            this.m_Canvas.repaint();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void setBytes(byte[] byArray) {
        this.m_Bytes = byArray;
        this.m_Canvas.repaint();
    }

    public InputStream getInput(File file) throws IOException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
            return gZIPInputStream;
        }
        catch (IOException iOException) {
            FileInputStream fileInputStream = new FileInputStream(file);
            return fileInputStream;
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            System.out.println(String.valueOf(hyperlinkEvent.getURL()) + " : " + hyperlinkEvent.getDescription());
            int n = this.m_Canvas.getPageNo();
            this.m_PageStack.push(n);
            String string = hyperlinkEvent.getURL().toString();
            int n2 = 0;
            int n3 = string.indexOf("#page");
            if (n3 >= 0) {
                String string2 = string.substring(n3 + 5);
                n2 = Integer.parseInt(string2);
            } else {
                n3 = string.indexOf("?page=");
                if (n3 >= 0) {
                    String string3 = string.substring(n3 + 6);
                    n2 = Integer.parseInt(string3);
                }
            }
            ((Navigator)this.m_NavPanel.getNavigation()).gotoPage(n2);
        }
    }

    private static boolean startsWith(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private class Canvas
    extends JComponent {
        private Dimension m_Size = new Dimension(800, 800);

        private Canvas() {
        }

        @Override
        public Dimension getPreferredSize() {
            int n = ((Zoom)Viewer.this.m_ZoomLevels.getSelectedItem()).getPercent();
            return new Dimension(this.m_Size.width * n / 100, this.m_Size.height * n / 100);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void render(IGlint iGlint) {
            if (Viewer.this.m_Bytes == null) {
                return;
            }
            if (Viewer.this.m_EyeReader != null) {
                this.renderEye(iGlint);
            } else {
                this.renderGlint(iGlint);
            }
        }

        protected void renderEye(IGlint iGlint) {
            Viewer.this.m_EyeReader.getResources(iGlint);
            Viewer.this.m_EyeReader.getPage(this.getPageNo(), iGlint);
            this.m_Size.width = Viewer.this.m_EyeReader.getWidth();
            this.m_Size.height = Viewer.this.m_EyeReader.getHeight();
        }

        protected void renderGlint(IGlint iGlint) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Viewer.this.m_Bytes);
            GlintInput.read((InputStream)byteArrayInputStream, (boolean)true, (IGlint)iGlint);
            this.m_Size.width = iGlint.getWidth();
            this.m_Size.height = iGlint.getHeight();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.setColor(Color.gray);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            if (Viewer.this.m_Bytes == null) {
                return;
            }
            if (Viewer.this.m_EyeReader != null) {
                this.paintEye(graphics);
            } else {
                this.paintGlint(graphics);
            }
        }

        protected void paintEye(Graphics graphics) {
            IGlint iGlint = this.getGlint(graphics);
            Viewer.this.m_EyeReader.getResources(iGlint);
            Viewer.this.m_EyeReader.getPage(this.getPageNo(), iGlint);
            this.setURLMap(iGlint);
        }

        protected void paintGlint(Graphics graphics) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Viewer.this.m_Bytes);
            try {
                IGlint iGlint = this.getGlint(graphics);
                GlintInput.read((InputStream)byteArrayInputStream, (boolean)true, (IGlint)iGlint);
                this.setURLMap(iGlint);
            }
            catch (GlintException glintException) {
                System.out.println((Object)glintException);
            }
        }

        public IGlint getGlint(Graphics graphics) {
            if (Viewer.this.m_G2D.isSelected()) {
                int n = ((Zoom)Viewer.this.m_ZoomLevels.getSelectedItem()).getPercent();
                return new GlintGraphics2D((Graphics2D)graphics, (double)n);
            }
            return new GlintGraphics(graphics);
        }

        private void setURLMap(IGlint iGlint) {
            if (iGlint instanceof GlintGraphics2D) {
                Viewer.this.m_GLListener.setURLMap(((GlintGraphics2D)iGlint).getURLMap());
            } else if (iGlint instanceof GlintGraphics) {
                // empty if block
            }
        }

        public int getPageNo() {
            return ((Navigator)Viewer.this.m_NavPanel.getNavigation()).getPageNo();
        }
    }

    private static class Zoom {
        public static final Zoom[] LEVELS = new Zoom[]{new Zoom(50), new Zoom(75), new Zoom(100), new Zoom(150), new Zoom(200), new Zoom(300), new Zoom(400)};
        private int m_Percent;

        public Zoom(int n) {
            this.m_Percent = n;
        }

        public int getPercent() {
            return this.m_Percent;
        }

        public String toString() {
            return this.m_Percent + "%";
        }
    }

    private class Navigator
    implements INavigation {
        private int m_CurrentPage;
        private int m_PageCount;

        private Navigator() {
        }

        public void setPageCount(int n) {
            this.m_PageCount = n;
            this.m_CurrentPage = n > 0 ? 1 : 0;
            Viewer.this.m_Canvas.repaint();
        }

        @Override
        public void first() {
            this.m_CurrentPage = 1;
            this.refresh();
        }

        @Override
        public boolean previous() {
            if (this.m_CurrentPage > 1) {
                --this.m_CurrentPage;
                this.refresh();
                return true;
            }
            return false;
        }

        @Override
        public boolean next() {
            if (this.m_CurrentPage < this.m_PageCount) {
                ++this.m_CurrentPage;
                this.refresh();
                return true;
            }
            return false;
        }

        @Override
        public void last() {
            this.m_CurrentPage = this.m_PageCount;
            this.refresh();
        }

        @Override
        public boolean gotoPage(int n) {
            if (n >= 1 && n <= this.m_PageCount) {
                this.m_CurrentPage = n;
                this.refresh();
                return true;
            }
            return false;
        }

        @Override
        public int getPageCount() {
            return this.m_PageCount;
        }

        @Override
        public int getPageNo() {
            return this.m_CurrentPage;
        }

        private void refresh() {
            Viewer.this.m_Canvas.repaint();
        }
    }

    private class BookmarkListener
    implements TreeSelectionListener {
        private BookmarkListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
            TOC tOC = (TOC)defaultMutableTreeNode.getUserObject();
            Navigator navigator = (Navigator)Viewer.this.m_NavPanel.getNavigation();
            navigator.gotoPage(tOC.getPageNo());
        }
    }

    private class Drop
    implements DropTargetListener {
        private Drop() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.acceptDrop(1);
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    Viewer.this.loadFile((File)list.get(0));
                    dropTargetDropEvent.dropComplete(true);
                    return;
                }
            }
            catch (Exception exception) {
                System.out.println("Drop Error: " + exception.toString());
            }
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.dropComplete(false);
        }
    }
}

