/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.awt;

import com.elixirtech.glint.EyeReader;
import com.elixirtech.glint.IEye;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.awt.AWTViewerCanvas;
import com.elixirtech.glint.g2d.GlintGraphics2D;
import com.elixirtech.glint.g2d.URLMap;
import com.elixirtech.print.Printable;
import com.elixirtech.util.StrBuffer;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;

public class AWTGlintCanvas
extends AWTViewerCanvas
implements Printable {
    private static final long serialVersionUID = 1L;
    private transient IEye m_Eye;
    private boolean m_Scrolled = true;
    private boolean m_HighlightURLS;
    private URLMap m_URLMap;

    public AWTGlintCanvas() {
        try {
            this.m_HighlightURLS = "true".equals(System.getProperty("glint.highlight.urls"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void setObject(Object object) {
        this.m_Eye = (IEye)object;
    }

    @Override
    public void read(InputStream inputStream) throws IOException {
        this.m_PageNo = 1;
        this.m_Eye = new EyeReader(inputStream);
    }

    public void setEye(IEye iEye) {
        this.m_Eye = iEye;
    }

    public IEye getEye() {
        return this.m_Eye;
    }

    public void setScrolled(boolean bl) {
        this.m_Scrolled = bl;
    }

    public boolean isScrolled() {
        return this.m_Scrolled;
    }

    public void setHighlightURLs(boolean bl) {
        this.m_HighlightURLS = bl;
    }

    public boolean isHighlightURLs() {
        return this.m_HighlightURLS;
    }

    @Override
    public int getPageCount() {
        if (this.m_Eye == null) {
            return 0;
        }
        return this.m_Eye.getPageCount();
    }

    @Override
    public int getNumberOfPages() {
        if (this.m_Eye == null) {
            return 0;
        }
        return this.m_Eye.getPageCount();
    }

    @Override
    public void update() {
        this.updateSize();
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_Eye != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.m_BitmapZoom && this.m_ZoomPercent > 100) {
                int n = this.m_Eye.getWidth() / 20;
                int n2 = this.m_Eye.getHeight() / 20;
                BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
                Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
                hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                hashMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                graphics2D2.setRenderingHints(hashMap);
                graphics2D2.setClip(0, 0, n, n2);
                GlintGraphics2D glintGraphics2D = new GlintGraphics2D(graphics2D2);
                this.m_Eye.getResources((IGlint)glintGraphics2D);
                this.m_Eye.getPage(this.m_PageNo, (IGlint)glintGraphics2D);
                this.m_URLMap = glintGraphics2D.getURLMap();
                if (this.m_HighlightURLS) {
                    this.showURLs(graphics2D2, this.m_URLMap);
                }
                glintGraphics2D.flush();
                graphics2D2.dispose();
                graphics2D.drawImage(bufferedImage, 0, 0, n * this.m_ZoomPercent / 100, n2 * this.m_ZoomPercent / 100, null);
                bufferedImage.flush();
            } else if (this.m_Eye.getPageCount() > 0) {
                HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
                hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                hashMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                graphics2D.setRenderingHints(hashMap);
                GlintGraphics2D glintGraphics2D = new GlintGraphics2D(graphics2D, (double)this.m_ZoomPercent);
                this.m_Eye.getResources((IGlint)glintGraphics2D);
                this.m_Eye.getPage(this.m_PageNo, (IGlint)glintGraphics2D);
                this.m_URLMap = glintGraphics2D.getURLMap();
                if (this.m_HighlightURLS) {
                    this.showURLs(graphics2D, this.m_URLMap);
                }
                glintGraphics2D.flush();
            }
        }
    }

    @Override
    public PageFormat getPageFormat(int n) {
        IEye.PageSetup pageSetup = this.m_Eye.getPageSetup(n + 1);
        Paper paper = new Paper();
        PageFormat pageFormat = new PageFormat();
        if (pageSetup.orientation == 2) {
            paper.setSize(pageSetup.height / 20, pageSetup.width / 20);
            paper.setImageableArea(0.0, 0.0, pageSetup.height / 20, pageSetup.width / 20);
            pageFormat.setOrientation(0);
        } else {
            paper.setSize(pageSetup.width / 20, pageSetup.height / 20);
            paper.setImageableArea(0.0, 0.0, pageSetup.width / 20, pageSetup.height / 20);
            pageFormat.setOrientation(1);
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n < 0 || n >= this.getPageCount()) {
            return 1;
        }
        GlintGraphics2D glintGraphics2D = new GlintGraphics2D((Graphics2D)graphics);
        this.m_Eye.getResources((IGlint)glintGraphics2D);
        this.m_Eye.getPage(n + 1, (IGlint)glintGraphics2D);
        return 0;
    }

    @Override
    public java.awt.print.Printable getPrintable(int n) {
        return this;
    }

    @Override
    public String getStatus() {
        StrBuffer strBuffer = new StrBuffer();
        if (this.m_Eye != null) {
            strBuffer.append("res=" + this.m_Eye.getResources(0).length + " bytes ");
            strBuffer.append(" page=" + this.m_Eye.getPage(this.m_PageNo).length + " bytes ");
        }
        return strBuffer.toString();
    }

    public URLMap getURLMap() {
        return this.m_URLMap;
    }

    private void showURLs(Graphics2D graphics2D, URLMap uRLMap) {
        graphics2D.setPaint(new Color(-2132746160, true));
        graphics2D.scale(0.05, 0.05);
        Iterator iterator = uRLMap.getStructIterator();
        while (iterator.hasNext()) {
            ((URLMap.URLStruct)iterator.next()).paint(graphics2D);
        }
        graphics2D.scale(20.0, 20.0);
    }

    private void updateSize() {
        if (this.m_Eye != null) {
            int n = this.m_Eye.getWidth() / 20;
            int n2 = this.m_Eye.getHeight() / 20;
            n = n * this.m_ZoomPercent / 100;
            n2 = n2 * this.m_ZoomPercent / 100;
            this.m_Dimension = new Dimension(n, n2);
        } else {
            this.m_Dimension = DEFAULT_SIZE;
        }
        this.invalidate();
        if (this.m_Scrolled) {
            Container container = this.getParent();
            if (container != null) {
                container = container.getParent();
            }
            if (container != null) {
                container = container.getParent();
            }
            if (container != null) {
                container.validate();
            }
        }
    }
}

