/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.awt;

import com.elixirtech.glint.awt.IViewerCanvas;
import com.elixirtech.glint.viewer.Zoomable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AWTViewerCanvas
extends Component
implements IViewerCanvas,
Zoomable,
Serializable {
    protected static final Dimension DEFAULT_SIZE = new Dimension(700, 800);
    protected Dimension m_Dimension = DEFAULT_SIZE;
    protected int m_PageNo = 1;
    protected int m_ZoomPercent = 100;
    protected boolean m_BitmapZoom;
    protected List<ChangeListener> m_Listeners;
    private ChangeEvent m_ChangeEvent = new ChangeEvent(this);
    private Color m_BackgroundColor = Color.gray;

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (this.m_Listeners == null) {
            this.m_Listeners = new ArrayList<ChangeListener>();
        }
        this.m_Listeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        if (this.m_Listeners != null) {
            this.m_Listeners.remove(changeListener);
        }
    }

    @Override
    public abstract void setObject(Object var1);

    @Override
    public abstract void read(InputStream var1) throws IOException;

    @Override
    public abstract void update();

    @Override
    public abstract int getPageCount();

    @Override
    public abstract String getStatus();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.read(fileInputStream);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void setZoomPercent(int n) {
        this.m_ZoomPercent = n;
    }

    @Override
    public int getZoomPercent() {
        return this.m_ZoomPercent;
    }

    @Override
    public void setBitmapZoom(boolean bl) {
        this.m_BitmapZoom = bl;
    }

    @Override
    public boolean isBitmapZoom() {
        return this.m_BitmapZoom;
    }

    public void setBackgroundColor(Color color) {
        this.m_BackgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.m_BackgroundColor;
    }

    @Override
    public void setPageNo(int n) {
        this.m_PageNo = n;
        this.fireChanged();
    }

    @Override
    public int getPageNo() {
        return this.m_PageNo;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.m_Dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.m_Dimension;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.m_Dimension;
    }

    @Override
    public Component getCanvasComponent() {
        return this;
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.m_BackgroundColor);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }

    @Override
    public void first() {
        this.m_PageNo = 1;
        this.repaint();
        this.fireChanged();
    }

    @Override
    public boolean previous() {
        if (this.m_PageNo > 1) {
            --this.m_PageNo;
            this.repaint();
            this.fireChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean next() {
        if (this.m_PageNo < this.getPageCount()) {
            ++this.m_PageNo;
            this.repaint();
            this.fireChanged();
            return true;
        }
        return false;
    }

    @Override
    public void last() {
        this.m_PageNo = this.getPageCount();
        this.repaint();
    }

    @Override
    public boolean gotoPage(int n) {
        if (n >= 1 && n <= this.getPageCount()) {
            this.m_PageNo = n;
            this.repaint();
            this.fireChanged();
            return true;
        }
        return false;
    }

    protected void fireChanged() {
        if (this.m_Listeners != null) {
            for (ChangeListener changeListener : this.m_Listeners) {
                changeListener.stateChanged(this.m_ChangeEvent);
            }
        }
    }
}

