/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.awt;

import com.elixirtech.glint.awt.IViewerCanvas;
import com.elixirtech.glint.awt.JNavigationPanel;
import com.elixirtech.glint.viewer.Zoomable;
import com.elixirtech.print.Printable;
import com.elixirtech.ui.INavigation;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ViewerToolBar
extends Panel
implements ActionListener {
    private static final String[] ZOOM_LABELS = new String[]{"50%", "75%", "100%", "150%", "200%", "300%", "400%", "800%", "1000%", "2000%"};
    private static final int[] ZOOM_VALUES = new int[]{50, 75, 100, 150, 200, 300, 400, 800, 1000, 2000};
    public static final int OPEN = 1;
    public static final int PRINT = 2;
    public static final int ZOOM = 4;
    public static final int NAVIGATE = 8;
    public static final int SAVE = 16;
    private IViewerCanvas m_Bean;
    private Choice m_Zoom;
    private Button m_Open;
    private Button m_Print;
    private JNavigationPanel m_NavPanel;

    public ViewerToolBar() {
        this(31);
    }

    public ViewerToolBar(int n) {
        this.setLayout(new FlowLayout(0, 5, 0));
        if ((n & 4) != 0) {
            this.m_Zoom = new Choice();
            for (int i = 0; i < ZOOM_LABELS.length; ++i) {
                this.m_Zoom.add(ZOOM_LABELS[i]);
            }
            this.m_Zoom.select(2);
            this.m_Zoom.setEnabled(false);
            this.m_Zoom.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ViewerToolBar.this.setZoomPercent(ZOOM_VALUES[ViewerToolBar.this.m_Zoom.getSelectedIndex()]);
                }
            });
            this.add(this.m_Zoom);
        }
        if ((n & 8) != 0) {
            this.m_NavPanel = new JNavigationPanel(new Navigator());
            this.add(this.m_NavPanel);
        }
        if ((n & 1) != 0) {
            this.m_Open = new Button("Open");
            this.m_Open.setActionCommand("Open");
            this.m_Open.setEnabled(false);
            this.m_Open.addActionListener(this);
            this.add(this.m_Open);
        }
        if ((n & 2) != 0) {
            this.m_Print = new Button("Print");
            this.m_Print.setActionCommand("Print");
            this.m_Print.addActionListener(this);
            this.add(this.m_Print);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Open")) {
            FileDialog fileDialog = new FileDialog(this.getFrame(), "Open", 0);
            fileDialog.setVisible(true);
            String string = fileDialog.getDirectory() + File.separator + fileDialog.getFile();
            this.open(new File(string));
        } else if (actionEvent.getActionCommand().equals("Print")) {
            // empty if block
        }
    }

    public void open(File file) {
        if (this.m_Bean != null && file.exists()) {
            try {
                this.m_Bean.read(file);
                if (this.m_NavPanel != null) {
                    this.m_NavPanel.refresh();
                    this.m_NavPanel.setStatus();
                }
                if (this.m_Bean instanceof Zoomable && this.m_Zoom != null) {
                    ((Zoomable)((Object)this.m_Bean)).setZoomPercent(ZOOM_VALUES[this.m_Zoom.getSelectedIndex()]);
                }
                this.m_Bean.update();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void open(Object object) {
        if (this.m_Bean != null) {
            this.m_Bean.setObject(object);
            if (this.m_NavPanel != null) {
                this.m_NavPanel.refresh();
                this.m_NavPanel.setStatus();
            }
            if (this.m_Bean instanceof Zoomable && this.m_Zoom != null) {
                ((Zoomable)((Object)this.m_Bean)).setZoomPercent(ZOOM_VALUES[this.m_Zoom.getSelectedIndex()]);
            }
            this.m_Bean.update();
        }
    }

    public void open(InputStream inputStream) {
        if (this.m_Bean != null) {
            try {
                this.m_Bean.read(inputStream);
                if (this.m_NavPanel != null) {
                    this.m_NavPanel.refresh();
                    this.m_NavPanel.setStatus();
                }
                if (this.m_Bean instanceof Zoomable && this.m_Zoom != null) {
                    ((Zoomable)((Object)this.m_Bean)).setZoomPercent(ZOOM_VALUES[this.m_Zoom.getSelectedIndex()]);
                }
                this.m_Bean.update();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setViewer(IViewerCanvas iViewerCanvas) {
        this.m_Bean = iViewerCanvas;
        int n = this.m_Bean.getPageCount();
        if (this.m_Zoom != null) {
            this.m_Zoom.setEnabled(this.m_Bean instanceof Zoomable);
        }
        if (this.m_Print != null) {
            this.m_Print.setEnabled(this.m_Bean instanceof Printable && n > 0);
        }
        if (this.m_Open != null) {
            this.m_Open.setEnabled(this.m_Bean != null);
        }
        if (this.m_NavPanel != null) {
            INavigation iNavigation = this.m_NavPanel.getNavigation();
            if (iNavigation.getPageCount() > 0) {
                iNavigation.first();
            }
            this.m_NavPanel.refresh();
            this.m_NavPanel.setStatus();
        }
        if (this.m_Bean instanceof Zoomable && this.m_Zoom != null) {
            ((Zoomable)((Object)this.m_Bean)).setZoomPercent(ZOOM_VALUES[this.m_Zoom.getSelectedIndex()]);
        }
    }

    public IViewerCanvas getViewer() {
        return this.m_Bean;
    }

    private void setZoomPercent(int n) {
        if (this.m_Bean instanceof Zoomable) {
            ((Zoomable)((Object)this.m_Bean)).setZoomPercent(n);
            this.m_Bean.update();
        }
    }

    private Frame getFrame() {
        Container container = this.getParent();
        while (!(container instanceof Frame)) {
            if ((container = container.getParent()) != null) continue;
            return null;
        }
        return (Frame)container;
    }

    private class Navigator
    implements INavigation {
        private Navigator() {
        }

        @Override
        public void first() {
            if (ViewerToolBar.this.m_Bean != null) {
                ViewerToolBar.this.m_Bean.first();
            }
        }

        @Override
        public boolean previous() {
            if (ViewerToolBar.this.m_Bean != null) {
                return ViewerToolBar.this.m_Bean.previous();
            }
            return false;
        }

        @Override
        public boolean next() {
            if (ViewerToolBar.this.m_Bean != null) {
                return ViewerToolBar.this.m_Bean.next();
            }
            return false;
        }

        @Override
        public void last() {
            if (ViewerToolBar.this.m_Bean != null) {
                ViewerToolBar.this.m_Bean.last();
            }
        }

        @Override
        public boolean gotoPage(int n) {
            if (ViewerToolBar.this.m_Bean != null) {
                return ViewerToolBar.this.m_Bean.gotoPage(n);
            }
            return false;
        }

        @Override
        public int getPageCount() {
            if (ViewerToolBar.this.m_Bean != null) {
                return ViewerToolBar.this.m_Bean.getPageCount();
            }
            return 0;
        }

        @Override
        public int getPageNo() {
            if (ViewerToolBar.this.m_Bean != null) {
                return ViewerToolBar.this.m_Bean.getPageNo();
            }
            return 0;
        }
    }
}

