/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics.font;

import com.elixirtech.graphics.font.Font;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.graphics.font.IFontMeasurerFactory;
import com.elixirtech.util.StringUtil;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.util.HashMap;
import java.util.Map;

public class AWTFontMeasurerFactory
implements IFontMeasurerFactory {
    private final boolean m_AntiAlias;
    private final boolean m_UseFractionalFontMetrics;
    private final FontRenderContext m_FRC;
    private Map<Font, IFontMeasurer> m_Map = new HashMap<Font, IFontMeasurer>();
    private static FontRenderContext TT = new FontRenderContext(null, true, true);
    private static FontRenderContext FF = new FontRenderContext(null, false, false);
    private static FontRenderContext TF = new FontRenderContext(null, true, false);
    private static FontRenderContext FT = new FontRenderContext(null, false, true);

    public AWTFontMeasurerFactory() {
        this(true, true);
    }

    public AWTFontMeasurerFactory(boolean bl, boolean bl2) {
        this.m_AntiAlias = bl;
        this.m_UseFractionalFontMetrics = bl2;
        this.m_FRC = this.m_AntiAlias ? (this.m_UseFractionalFontMetrics ? TT : TF) : (this.m_UseFractionalFontMetrics ? FT : FF);
    }

    @Override
    public IFontMeasurer getInstance(Font font) {
        IFontMeasurer iFontMeasurer = this.m_Map.get(font);
        if (iFontMeasurer == null) {
            iFontMeasurer = new AWTFontMeasurer(font);
            this.m_Map.put(font, iFontMeasurer);
        }
        return iFontMeasurer;
    }

    public IFontMeasurer getInstance(java.awt.Font font) {
        return new AWTFontMeasurer(font);
    }

    private class AWTFontMeasurer
    implements IFontMeasurer {
        private java.awt.Font m_Font;
        private LineMetrics m_LineMetrics;

        public AWTFontMeasurer(Font font) {
            int n = font.isBold() ? 1 : 0;
            this.m_Font = new java.awt.Font(font.getName(), n |= font.isItalic() ? 2 : 0, font.getSize() / 20);
            this.m_Font = this.m_Font.deriveFont((float)font.getSize() / 20.0f);
            this.m_LineMetrics = this.m_Font.getLineMetrics("Sample characters", AWTFontMeasurerFactory.this.m_FRC);
        }

        public AWTFontMeasurer(java.awt.Font font) {
            this.m_Font = font;
            this.m_LineMetrics = this.m_Font.getLineMetrics("Sample characters", AWTFontMeasurerFactory.this.m_FRC);
        }

        @Override
        public float getWidth(String string) {
            if (StringUtil.isEmpty(string)) {
                return 0.0f;
            }
            return (float)this.m_Font.getStringBounds(string, AWTFontMeasurerFactory.this.m_FRC).getWidth() * 20.0f;
        }

        @Override
        public float getWidth(String string, int n, int n2) {
            return this.getWidth(string.substring(n, n + n2));
        }

        @Override
        public float getWidth(char[] cArray, int n, int n2) {
            return (float)this.m_Font.getStringBounds(cArray, n, n2, AWTFontMeasurerFactory.this.m_FRC).getWidth() * 20.0f;
        }

        @Override
        public float getHeight() {
            return this.m_LineMetrics.getHeight() * 20.0f;
        }

        @Override
        public float getAscent() {
            return this.m_LineMetrics.getAscent() * 20.0f;
        }

        @Override
        public float getDescent() {
            return this.m_LineMetrics.getDescent() * 20.0f;
        }

        @Override
        public float getLeading() {
            return this.m_LineMetrics.getLeading() * 20.0f;
        }

        @Override
        public float getCharWidth(char c) {
            return this.getWidth(new char[]{c}, 0, 1);
        }
    }
}

