/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics.font;

import java.awt.Color;

public class Font {
    private String m_Name;
    private boolean m_Bold;
    private boolean m_Italic;
    private int m_Size;
    private Color m_Color;

    protected Font() {
    }

    public Font(String string, boolean bl, boolean bl2, int n) {
        this(string, bl, bl2, n, null);
    }

    public Font(Font font) {
        this(font.m_Name, font.m_Bold, font.m_Italic, font.m_Size, font.m_Color);
    }

    public Font(String string, boolean bl, boolean bl2, int n, Color color) {
        this.m_Name = string;
        this.m_Bold = bl;
        this.m_Italic = bl2;
        this.m_Size = n;
        this.m_Color = color;
    }

    public String getName() {
        return this.m_Name;
    }

    public boolean isBold() {
        return this.m_Bold;
    }

    public boolean isItalic() {
        return this.m_Italic;
    }

    public int getSize() {
        return this.m_Size;
    }

    public Color getColor() {
        return this.m_Color;
    }

    public boolean equals(Object object) {
        if (object instanceof Font) {
            Font font = (Font)object;
            if (this.m_Name.equals(font.m_Name) && this.m_Bold == font.m_Bold && this.m_Italic == font.m_Italic && this.m_Size == font.m_Size) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = this.m_Name.hashCode() << 2 | (this.m_Bold ? 2 : 0 | (this.m_Italic ? 1 : 0));
        n ^= this.m_Size << 16;
        if (this.m_Color != null) {
            n ^= this.m_Color.hashCode();
        }
        return n;
    }

    public Font merge(Font font) {
        Font font2 = new Font();
        font2.m_Name = font.m_Name != null ? font.m_Name : this.m_Name;
        font2.m_Bold = font.m_Bold | this.m_Bold;
        font2.m_Italic = font.m_Italic | this.m_Italic;
        font2.m_Size = font.m_Size != 0 ? font.m_Size : this.m_Size;
        font2.m_Color = font.m_Color != null ? font.m_Color : this.m_Color;
        return font2;
    }

    public String toString() {
        return "Font[" + this.m_Name + (this.m_Bold ? ",bold" : "") + (this.m_Italic ? ",italic" : "") + "," + this.m_Size + "pt]";
    }

    public static java.awt.Font getAWTFont20(Font font) {
        int n = 0;
        if (font.isBold()) {
            n |= 1;
        }
        if (font.isItalic()) {
            n |= 2;
        }
        return new java.awt.Font(font.getName(), n, font.getSize());
    }
}

