/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.guiapi.ambience;

import ambience.api.DSBridge;
import com.elixirtech.arch.GUIClientRequest$;
import com.elixirtech.arch.HttpClientResponse;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path$;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.SchemaItem;
import com.elixirtech.guiapi.ambience.AmbienceAdapter;
import com.elixirtech.guiapi.ambience.AmbienceDSBridge$SchemaColumn$;
import com.elixirtech.guiapi.ambience.AmbienceDSBridge$SchemaField$;
import com.elixirtech.guiapi.ambience.RemoteLogin$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Error;
import io.circe.Json;
import io.circe.Json$;
import io.circe.JsonObject;
import io.circe.ParsingFailure;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.DecoderNotDeriveSum;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Date;
import org.owasp.encoder.Encode;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class AmbienceDSBridge
implements DSBridge,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AmbienceDSBridge.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final AmbienceAdapter adapter;
    private final String datasetsList;
    private final String datasetsSchema;
    private final String datasetsRecords;
    private final DateTimeFormatter DateFormat;

    public AmbienceDSBridge(AmbienceAdapter adapter) {
        this.adapter = adapter;
        this.datasetsList = RemoteLogin$.MODULE$.buildUrl(adapter.userInfo().server(), Path$.MODULE$.apply("/datasets/list"));
        this.datasetsSchema = RemoteLogin$.MODULE$.buildUrl(adapter.userInfo().server(), Path$.MODULE$.apply("/datasets/schema"));
        this.datasetsRecords = RemoteLogin$.MODULE$.buildUrl(adapter.userInfo().server(), Path$.MODULE$.apply("/datasets/records-strict"));
        this.DateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DateTimeFormatter DateFormat() {
        return this.DateFormat;
    }

    public List<String> datasetNames() {
        this.log().info(AmbienceDSBridge::datasetNames$$anonfun$1, Line$.MODULE$.apply(29), FullName$.MODULE$.apply("com.elixirtech.guiapi.ambience.AmbienceDSBridge.datasetNames"));
        HttpClientResponse response = GUIClientRequest$.MODULE$.get(this.datasetsList, (Map<String, String>)Predef$.MODULE$.Map().empty(), (Map<String, String>)this.adapter.headers().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        if (response.statusCode() == 200) {
            Either either = io.circe.parser.package$.MODULE$.decode(response.bodyUtf8(), Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeString()));
            if (either instanceof Right) {
                List names = (List)((Right)either).value();
                return names;
            }
            if (either instanceof Left) {
                Error err = (Error)((Left)either).value();
                this.log().error(() -> AmbienceDSBridge.datasetNames$$anonfun$2(err), Line$.MODULE$.apply(35), FullName$.MODULE$.apply("com.elixirtech.guiapi.ambience.AmbienceDSBridge.datasetNames"));
                return package$.MODULE$.Nil();
            }
            throw new MatchError((Object)either);
        }
        this.log().error(() -> AmbienceDSBridge.datasetNames$$anonfun$3(response), Line$.MODULE$.apply(40), FullName$.MODULE$.apply("com.elixirtech.guiapi.ambience.AmbienceDSBridge.datasetNames"));
        return package$.MODULE$.Nil();
    }

    public Iterator<DataRecord> getRecords(String dataset, DataSchema schema, String inParamsOrEmpty) {
        Json json;
        this.log().info(() -> AmbienceDSBridge.getRecords$$anonfun$1(dataset, schema), Line$.MODULE$.apply(46), FullName$.MODULE$.apply("com.elixirtech.guiapi.ambience.AmbienceDSBridge.getRecords"));
        String safe = Encode.forUriComponent((String)dataset);
        String inParams = inParamsOrEmpty.trim().isEmpty() ? "{}" : inParamsOrEmpty;
        Either either = io.circe.parser.package$.MODULE$.parse(inParams);
        if (either instanceof Right) {
            Json json2;
            json = json2 = (Json)((Right)either).value();
        } else if (either instanceof Left) {
            ParsingFailure value = (ParsingFailure)((Left)either).value();
            this.log().info(() -> AmbienceDSBridge.$anonfun$1(inParams, value), Line$.MODULE$.apply(52), FullName$.MODULE$.apply("com.elixirtech.guiapi.ambience.AmbienceDSBridge.json"));
            json = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        } else {
            throw new MatchError((Object)either);
        }
        Json json3 = json;
        HttpClientResponse response = GUIClientRequest$.MODULE$.postJson(this.datasetsRecords + "/" + safe, json3, (Map<String, String>)this.adapter.headers().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        List<SchemaColumn> schemaColumns = this.buildSchemaColumns(schema);
        if (response.statusCode() == 200) {
            return StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(response.bodyUtf8())).flatMap((Function1 & Serializable)jsonLine -> this.toOptRecord(schema, schemaColumns, (String)jsonLine));
        }
        this.log().error(() -> AmbienceDSBridge.getRecords$$anonfun$3(dataset, response), Line$.MODULE$.apply(59), FullName$.MODULE$.apply("com.elixirtech.guiapi.ambience.AmbienceDSBridge.getRecords"));
        return package$.MODULE$.Iterator().empty();
    }

    public List<SchemaColumn> buildSchemaColumns(DataSchema schema) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(schema.getColumns()).asScala().map((Function1 & Serializable)col -> AmbienceDSBridge$SchemaColumn$.MODULE$.apply(col.name, col.type))).toList();
    }

    public Option<DataSchema> schema(String dataset) {
        this.log().info(() -> AmbienceDSBridge.schema$$anonfun$1(dataset), Line$.MODULE$.apply(69), FullName$.MODULE$.apply("com.elixirtech.guiapi.ambience.AmbienceDSBridge.schema"));
        String safe = Encode.forUriComponent((String)dataset);
        HttpClientResponse response = GUIClientRequest$.MODULE$.get(this.datasetsSchema + "?dataset=" + safe, (Map<String, String>)Predef$.MODULE$.Map().empty(), (Map<String, String>)this.adapter.headers().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        if (response.statusCode() == 200) {
            String string = "name";
            String string2 = "dataType";
            int size = 2;
            Either either = io.circe.parser.package$.MODULE$.decode(response.bodyUtf8(), Decoder$.MODULE$.decodeList(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("SchemaField", AmbienceDSBridge::schema$$anonfun$2, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), AmbienceDSBridge::schema$$anonfun$3, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(AmbienceDSBridge::schema$$anonfun$4))))));
            if (either instanceof Right) {
                List fields = (List)((Right)either).value();
                SchemaItem[] columns = (SchemaItem[])fields.map((Function1 & Serializable)field -> this.toSchemaItem((SchemaField)field)).toArray(ClassTag$.MODULE$.apply(SchemaItem.class));
                this.log().info(() -> AmbienceDSBridge.schema$$anonfun$5(dataset, columns), Line$.MODULE$.apply(76), FullName$.MODULE$.apply("com.elixirtech.guiapi.ambience.AmbienceDSBridge.schema"));
                return Some$.MODULE$.apply((Object)new DataSchema(true, columns));
            }
            if (either instanceof Left) {
                Error err = (Error)((Left)either).value();
                this.log().error(() -> AmbienceDSBridge.schema$$anonfun$6(err), Line$.MODULE$.apply(79), FullName$.MODULE$.apply("com.elixirtech.guiapi.ambience.AmbienceDSBridge.schema"));
                return None$.MODULE$;
            }
            throw new MatchError((Object)either);
        }
        this.log().error(() -> AmbienceDSBridge.schema$$anonfun$7(response), Line$.MODULE$.apply(84), FullName$.MODULE$.apply("com.elixirtech.guiapi.ambience.AmbienceDSBridge.schema"));
        return None$.MODULE$;
    }

    public Option<DataRecord> toOptRecord(DataSchema schema, List<SchemaColumn> schemaColumns, String jsonLine) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(jsonLine))) {
            Either either = io.circe.parser.package$.MODULE$.parse(jsonLine);
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return this.toRecord(schema, schemaColumns, json);
            }
            if (either instanceof Left) {
                ParsingFailure value = (ParsingFailure)((Left)either).value();
                this.log().error(() -> AmbienceDSBridge.toOptRecord$$anonfun$1(jsonLine, value), Line$.MODULE$.apply(94), FullName$.MODULE$.apply("com.elixirtech.guiapi.ambience.AmbienceDSBridge.toOptRecord"));
                return None$.MODULE$;
            }
            throw new MatchError((Object)either);
        }
        return None$.MODULE$;
    }

    public Option<DataRecord> toRecord(DataSchema schema, List<SchemaColumn> schemaColumns, Json json) {
        return json.asObject().map((Function1 & Serializable)obj -> new DataRecord(schema, (Object[])schemaColumns.map((Function1 & Serializable)col -> obj.apply(col.name()).map((Function1 & Serializable)json -> this.asType(col.dataType(), (Json)json)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).toArray(ClassTag$.MODULE$.apply(Object.class))));
    }

    public Object asType(DataType dataType, Json json) {
        None$ none$;
        if (json.isNull()) {
            return None$.MODULE$.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        DataType dataType2 = dataType;
        DataType dataType3 = DataType.BOOLEAN;
        DataType dataType4 = dataType2;
        if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
            none$ = json.asBoolean().map((Function1 & Serializable)x -> AmbienceDSBridge.$anonfun$3(BoxesRunTime.unboxToBoolean((Object)x)));
        } else {
            DataType dataType5 = DataType.BYTE_ARRAY;
            DataType dataType6 = dataType2;
            if (!(dataType5 != null ? !dataType5.equals(dataType6) : dataType6 != null)) {
                none$ = this.asBytes(json);
            } else {
                DataType dataType7 = DataType.DATE;
                DataType dataType8 = dataType2;
                if (!(dataType7 != null ? !dataType7.equals(dataType8) : dataType8 != null)) {
                    none$ = json.asString().flatMap((Function1 & Serializable)s -> this.asDate((String)s));
                } else {
                    DataType dataType9 = DataType.DECIMAL;
                    DataType dataType10 = dataType2;
                    if (!(dataType9 != null ? !dataType9.equals(dataType10) : dataType10 != null)) {
                        none$ = json.asObject().flatMap((Function1 & Serializable)obj -> this.asDecimal((JsonObject)obj));
                    } else {
                        DataType dataType11 = DataType.DOUBLE;
                        DataType dataType12 = dataType2;
                        if (!(dataType11 != null ? !dataType11.equals(dataType12) : dataType12 != null)) {
                            none$ = json.asObject().flatMap((Function1 & Serializable)obj -> this.asDouble((JsonObject)obj));
                        } else {
                            DataType dataType13 = DataType.LONG;
                            DataType dataType14 = dataType2;
                            if (!(dataType13 != null ? !dataType13.equals(dataType14) : dataType14 != null)) {
                                none$ = json.asObject().flatMap((Function1 & Serializable)obj -> this.asLong((JsonObject)obj));
                            } else {
                                DataType dataType15 = DataType.STRING;
                                DataType dataType16 = dataType2;
                                if (!(dataType15 != null ? !dataType15.equals(dataType16) : dataType16 != null)) {
                                    none$ = json.asString();
                                } else {
                                    DataType dataType17 = DataType.TIME;
                                    DataType dataType18 = dataType2;
                                    if (!(dataType17 != null ? !dataType17.equals(dataType18) : dataType18 != null)) {
                                        none$ = json.asString().flatMap((Function1 & Serializable)s -> this.asTime((String)s));
                                    } else {
                                        DataType dataType19 = DataType.TIMESTAMP;
                                        DataType dataType20 = dataType2;
                                        if (!(dataType19 != null ? !dataType19.equals(dataType20) : dataType20 != null)) {
                                            none$ = this.asTimestamp(json);
                                        } else {
                                            DataType dataType21 = DataType.UNKNOWN;
                                            DataType dataType22 = dataType2;
                                            none$ = !(dataType21 != null ? !dataType21.equals(dataType22) : dataType22 != null) ? None$.MODULE$ : None$.MODULE$;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        None$ ret = none$;
        return ret.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<Object> asBytes(Json json) {
        return json.hcursor().downField("$binary").downField("base64").as(Decoder$.MODULE$.decodeString()).toOption().flatMap((Function1 & Serializable)s -> Try$.MODULE$.apply(() -> AmbienceDSBridge.asBytes$$anonfun$1$$anonfun$1(s)).toOption());
    }

    public Option<Object> asLong(JsonObject obj) {
        return obj.apply("$numberLong").orElse(() -> AmbienceDSBridge.asLong$$anonfun$1(obj)).flatMap((Function1 & Serializable)_$1 -> _$1.asString()).flatMap((Function1 & Serializable)_$2 -> StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(_$2))).map((Function1 & Serializable)x -> AmbienceDSBridge.asLong$$anonfun$4(BoxesRunTime.unboxToLong((Object)x)));
    }

    public Option<Object> asDouble(JsonObject obj) {
        return obj.apply("$numberDouble").flatMap((Function1 & Serializable)_$3 -> _$3.asString()).flatMap((Function1 & Serializable)_$4 -> StringOps$.MODULE$.toDoubleOption$extension(Predef$.MODULE$.augmentString(_$4))).map((Function1 & Serializable)x -> AmbienceDSBridge.asDouble$$anonfun$3(BoxesRunTime.unboxToDouble((Object)x)));
    }

    public Option<Object> asDecimal(JsonObject obj) {
        return obj.apply("$numberDecimal").flatMap((Function1 & Serializable)_$5 -> _$5.asString()).map((Function1 & Serializable)_$6 -> new BigDecimal((String)_$6));
    }

    public Option<Object> asDate(String s) {
        return Try$.MODULE$.apply(() -> this.asDate$$anonfun$1(s)).toOption();
    }

    public Option<Object> asTime(String s) {
        return Try$.MODULE$.apply(() -> AmbienceDSBridge.asTime$$anonfun$1(s)).toOption();
    }

    public Option<Object> asTimestamp(Json json) {
        return json.hcursor().downField("$date").downField("$numberLong").as(Decoder$.MODULE$.decodeString()).toOption().flatMap((Function1 & Serializable)ms2 -> StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(ms2)).map((Function1 & Serializable)ms -> AmbienceDSBridge.asTimestamp$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToLong((Object)ms))));
    }

    /*
     * Enabled aggressive block sorting
     */
    public SchemaItem toSchemaItem(SchemaField field) {
        DataType dataType;
        block16: {
            String string = field.dataType();
            switch (string == null ? 0 : string.hashCode()) {
                case -1808118735: {
                    if (!"String".equals(string)) break;
                    dataType = DataType.STRING;
                    break block16;
                }
                case -1088050383: {
                    if (!"Decimal".equals(string)) break;
                    dataType = DataType.DECIMAL;
                    break block16;
                }
                case 2363: {
                    if (!"Id".equals(string)) break;
                    dataType = DataType.UNKNOWN;
                    break block16;
                }
                case 63537721: {
                    if (!"Array".equals(string)) break;
                    dataType = DataType.UNKNOWN;
                    break block16;
                }
                case 70807150: {
                    if (!"Int32".equals(string)) break;
                    dataType = DataType.LONG;
                    break block16;
                }
                case 70807245: {
                    if (!"Int64".equals(string)) break;
                    dataType = DataType.LONG;
                    break block16;
                }
                case 802240212: {
                    if (!"IsoLocalDate".equals(string)) break;
                    dataType = DataType.DATE;
                    break block16;
                }
                case 802724339: {
                    if (!"IsoLocalTime".equals(string)) break;
                    dataType = DataType.TIME;
                    break block16;
                }
                case 926364987: {
                    if (!"Document".equals(string)) break;
                    dataType = DataType.UNKNOWN;
                    break block16;
                }
                case 1379812394: {
                    if (!"Unknown".equals(string)) break;
                    dataType = DataType.UNKNOWN;
                    break block16;
                }
                case 1729365000: {
                    if (!"Boolean".equals(string)) break;
                    dataType = DataType.BOOLEAN;
                    break block16;
                }
                case 1989867553: {
                    if (!"Binary".equals(string)) break;
                    dataType = DataType.UNKNOWN;
                    break block16;
                }
                case 2052876273: {
                    if (!"Double".equals(string)) break;
                    dataType = DataType.DOUBLE;
                    break block16;
                }
                case 2059094262: {
                    if (!"Timestamp".equals(string)) break;
                    dataType = DataType.TIMESTAMP;
                    break block16;
                }
            }
            dataType = DataType.UNKNOWN;
        }
        DataType dt = dataType;
        return new SchemaItem(field.name(), dt);
    }

    private static final Object datasetNames$$anonfun$1() {
        return "loading datasetNames";
    }

    private static final Object datasetNames$$anonfun$2(Error err$1) {
        return "Can't parse datasetNames: " + err$1;
    }

    private static final Object datasetNames$$anonfun$3(HttpClientResponse response$1) {
        return "datasetNames response " + response$1.statusCode() + ": " + response$1.bodyUtf8();
    }

    private static final Object getRecords$$anonfun$1(String dataset$1, DataSchema schema$1) {
        return "getting records from " + dataset$1 + " (" + schema$1.getColumnCount() + " columns)";
    }

    private static final Object $anonfun$1(String inParams$1, ParsingFailure value$1) {
        return "Invalid inParams " + inParams$1 + ": " + value$1;
    }

    private static final Object getRecords$$anonfun$3(String dataset$2, HttpClientResponse response$2) {
        return "getRecords error dataset=" + dataset$2 + " status=" + response$2.statusCode() + ": " + response$2.bodyUtf8();
    }

    private static final Object schema$$anonfun$1(String dataset$3) {
        return "loading " + dataset$3 + " schema";
    }

    private static final List schema$$anonfun$2() {
        Decoder decodeA;
        Decoder decodeA2;
        DecoderNotDeriveSum f$proxy1;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy1 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy1;
        Configuration x$2$proxy2 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 schema$$anonfun$3() {
        AmbienceDSBridge$SchemaField$ ambienceDSBridge$SchemaField$ = AmbienceDSBridge$SchemaField$.MODULE$;
        return (Function1 & Serializable)p -> (SchemaField)ambienceDSBridge$SchemaField$.fromProduct((Product)p);
    }

    private static final Product schema$$anonfun$4() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Object schema$$anonfun$5(String dataset$4, SchemaItem[] columns$1) {
        return dataset$4 + " has " + columns$1.length + " columns";
    }

    private static final Object schema$$anonfun$6(Error err$2) {
        return "Can't parse dataset schema: " + err$2;
    }

    private static final Object schema$$anonfun$7(HttpClientResponse response$3) {
        return "datasetSchema response " + response$3.statusCode() + ": " + response$3.bodyUtf8();
    }

    private static final Object toOptRecord$$anonfun$1(String jsonLine$1, ParsingFailure value$2) {
        return "Can't parse line: " + jsonLine$1 + ": " + value$2;
    }

    private static final /* synthetic */ Boolean $anonfun$3(boolean x) {
        return BoxesRunTime.boxToBoolean((boolean)x);
    }

    private static final byte[] asBytes$$anonfun$1$$anonfun$1(String s$1) {
        return Base64.getDecoder().decode(s$1);
    }

    private static final Option asLong$$anonfun$1(JsonObject obj$2) {
        return obj$2.apply("$numberInt");
    }

    private static final /* synthetic */ Long asLong$$anonfun$4(long x) {
        return BoxesRunTime.boxToLong((long)x);
    }

    private static final /* synthetic */ Double asDouble$$anonfun$3(double x) {
        return BoxesRunTime.boxToDouble((double)x);
    }

    private final Date asDate$$anonfun$1(String s$2) {
        LocalDate localDate = LocalDate.parse(s$2, this.DateFormat());
        return new Date(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    private static final Date asTime$$anonfun$1(String s$3) {
        LocalTime localTime = LocalTime.parse(s$3);
        return new Date(localTime.toNanoOfDay() / 1000000L);
    }

    private static final /* synthetic */ Date asTimestamp$$anonfun$1$$anonfun$1(long ms) {
        return new Date(ms);
    }

    public static final class SchemaColumn
    implements Product,
    Serializable {
        private final String name;
        private final DataType dataType;

        public static SchemaColumn apply(String string, DataType dataType) {
            return AmbienceDSBridge$SchemaColumn$.MODULE$.apply(string, dataType);
        }

        public static SchemaColumn fromProduct(Product product) {
            return AmbienceDSBridge$SchemaColumn$.MODULE$.fromProduct(product);
        }

        public static SchemaColumn unapply(SchemaColumn schemaColumn) {
            return AmbienceDSBridge$SchemaColumn$.MODULE$.unapply(schemaColumn);
        }

        public SchemaColumn(String name, DataType dataType) {
            this.name = name;
            this.dataType = dataType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SchemaColumn)) return false;
            SchemaColumn schemaColumn = (SchemaColumn)object;
            String string = this.name();
            String string2 = schemaColumn.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            DataType dataType = this.dataType();
            DataType dataType2 = schemaColumn.dataType();
            if (dataType == null) {
                if (dataType2 == null) return true;
                return false;
            } else {
                if (!dataType.equals(dataType2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SchemaColumn;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SchemaColumn";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "dataType";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public DataType dataType() {
            return this.dataType;
        }

        public SchemaColumn copy(String name, DataType dataType) {
            return new SchemaColumn(name, dataType);
        }

        public String copy$default$1() {
            return this.name();
        }

        public DataType copy$default$2() {
            return this.dataType();
        }

        public String _1() {
            return this.name();
        }

        public DataType _2() {
            return this.dataType();
        }
    }

    public static final class SchemaField
    implements Product,
    Serializable {
        private final String name;
        private final String dataType;

        public static SchemaField apply(String string, String string2) {
            return AmbienceDSBridge$SchemaField$.MODULE$.apply(string, string2);
        }

        public static SchemaField fromProduct(Product product) {
            return AmbienceDSBridge$SchemaField$.MODULE$.fromProduct(product);
        }

        public static SchemaField unapply(SchemaField schemaField) {
            return AmbienceDSBridge$SchemaField$.MODULE$.unapply(schemaField);
        }

        public SchemaField(String name, String dataType) {
            this.name = name;
            this.dataType = dataType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SchemaField)) return false;
            SchemaField schemaField = (SchemaField)object;
            String string = this.name();
            String string2 = schemaField.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.dataType();
            String string4 = schemaField.dataType();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SchemaField;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SchemaField";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "dataType";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public String dataType() {
            return this.dataType;
        }

        public SchemaField copy(String name, String dataType) {
            return new SchemaField(name, dataType);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.dataType();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.dataType();
        }
    }
}

