/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.guiapi.local;

import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.Path;
import com.elixirtech.guiapi.RepositoryInterface;
import com.elixirtech.guiapi.RepositoryInterface$RFile$;
import com.elixirtech.guiapi.RepositoryInterface$RFolder$;
import com.typesafe.config.Config;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class LocalRepositoryInterface
implements RepositoryInterface {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(LocalRepositoryInterface.class.getDeclaredField("repRootDir$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LocalRepositoryInterface.class.getDeclaredField("repRoot$lzy1"));
    private volatile Object repRoot$lzy1;
    private volatile Object repRootDir$lzy1;

    public LocalRepositoryInterface() {
        this.repRootDir().mkdirs();
    }

    public String repRoot() {
        Object object = this.repRoot$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.repRoot$lzyINIT1();
    }

    private Object repRoot$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.repRoot$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ((Config)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Config.class))).getString("ambience.gui.repository-root");
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.repRoot$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public File repRootDir() {
        Object object = this.repRootDir$lzy1;
        if (object instanceof File) {
            return (File)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (File)this.repRootDir$lzyINIT1();
    }

    private Object repRootDir$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.repRootDir$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    File file = null;
                    try {
                        file = new File(this.repRoot());
                        object2 = file == null ? LazyVals.NullValue$.MODULE$ : file;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.repRootDir$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return file;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public String label() {
        return "Local Repository Interface";
    }

    @Override
    public Task<Option<RepositoryInterface.RItem>> propertiesT(Path path) {
        return Task$.MODULE$.apply(() -> this.propertiesT$$anonfun$1(path));
    }

    @Override
    public Task<Option<byte[]>> readFileT(Path path) {
        return Task$.MODULE$.apply(() -> this.readFileT$$anonfun$1(path));
    }

    @Override
    public Task<BoxedUnit> writeFileT(Path path, byte[] bytes, boolean overwrite) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.writeFileT$$anonfun$1(path, overwrite, bytes);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Observable<RepositoryInterface.RItem> getChildrenT(Path path) {
        File file = this.newFile(path.toRelativeString());
        if (file.isFile()) {
            return Observable$.MODULE$.empty();
        }
        List children = Predef$.MODULE$.wrapRefArray((Object[])Option$.MODULE$.apply((Object)file.listFiles()).getOrElse(LocalRepositoryInterface::$anonfun$1)).toList();
        List ritems = children.map((Function1 & Serializable)f -> {
            if (f.isFile()) {
                return RepositoryInterface$RFile$.MODULE$.apply(path.$div(f.getName()), f.length(), "", f.lastModified());
            }
            return RepositoryInterface$RFolder$.MODULE$.apply(path.$div(f.getName()));
        });
        return Observable$.MODULE$.fromIterable((Iterable)ritems);
    }

    @Override
    public Task<BoxedUnit> addFolderT(Path base, String name) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.addFolderT$$anonfun$1(base, name);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Task<BoxedUnit> deleteFileT(Path path) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.deleteFileT$$anonfun$1(path);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Task<BoxedUnit> deleteFolderT(Path path) {
        return Task$.MODULE$.apply(() -> this.deleteFolderT$$anonfun$1(path)).flatMap((Function1 & Serializable)file -> Task$.MODULE$.apply(() -> LocalRepositoryInterface.deleteFolderT$$anonfun$2$$anonfun$1(file)).flatMap((Function1 & Serializable)directChildren -> this.recurseDelete(path, (List<File>)directChildren).map((Function1 & Serializable)_$1 -> file.delete()).map((Function1 & Serializable)v1 -> {
            bl = BoxesRunTime.unboxToBoolean((Object)v1);
            return BoxedUnit.UNIT;
        })));
    }

    public Task<BoxedUnit> recurseDelete(Path base, List<File> list) {
        List<File> list2 = list;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<File> list3 = list2;
        if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
            return Task$.MODULE$.unit();
        }
        if (list2 instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list2;
            File file = (File)colon2.head();
            List list4 = colon2.next$access$1();
            File head = file;
            List tail = list4;
            if (head.isFile()) {
                return this.deleteFileT(base.$div(head.getName())).flatMap((Function1 & Serializable)_$2 -> this.recurseDelete(base, (List<File>)tail));
            }
            File head2 = file;
            List tail2 = list4;
            return this.deleteFolderT(base.$div(head2.getName())).flatMap((Function1 & Serializable)_$3 -> this.recurseDelete(base, (List<File>)tail2));
        }
        throw new MatchError(list2);
    }

    @Override
    public Task<Object> canReadT(Path path) {
        return Task$.MODULE$.apply(() -> this.canReadT$$anonfun$1(path));
    }

    @Override
    public Task<Object> canWriteT(Path path) {
        return Task$.MODULE$.apply(() -> this.canWriteT$$anonfun$1(path));
    }

    public File newFile(String path) {
        return new File(this.repRootDir(), path);
    }

    private final Option propertiesT$$anonfun$1(Path path$1) {
        File file = this.newFile(path$1.toRelativeString());
        if (file.exists()) {
            if (file.isDirectory()) {
                return Some$.MODULE$.apply((Object)RepositoryInterface$RFolder$.MODULE$.apply(path$1));
            }
            return Some$.MODULE$.apply((Object)RepositoryInterface$RFile$.MODULE$.apply(path$1, file.length(), "", file.lastModified()));
        }
        return None$.MODULE$;
    }

    private final Option readFileT$$anonfun$1(Path path$2) {
        File file = this.newFile(path$2.toRelativeString());
        if (file.exists() && file.isFile()) {
            return Some$.MODULE$.apply((Object)Files.readAllBytes(file.toPath()));
        }
        return None$.MODULE$;
    }

    private final void writeFileT$$anonfun$1(Path path$3, boolean overwrite$1, byte[] bytes$1) {
        File file = this.newFile(path$3.toRelativeString());
        if (file.exists() && !overwrite$1) {
            v0 = BoxedUnit.UNIT;
        } else {
            Files.deleteIfExists(file.toPath());
            v0 = Files.write(file.toPath(), bytes$1, new OpenOption[0]);
        }
    }

    private static final File[] $anonfun$1() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    private final void addFolderT$$anonfun$1(Path base$1, String name$1) {
        File file = new File(this.repRootDir(), base$1.toRelativeString() + name$1);
        Files.createDirectories(file.toPath(), new FileAttribute[0]);
    }

    private final void deleteFileT$$anonfun$1(Path path$5) {
        File file = this.newFile(path$5.toRelativeString());
        if (file.isFile()) {
            Files.deleteIfExists(file.toPath());
        }
    }

    private final File deleteFolderT$$anonfun$1(Path path$6) {
        return this.newFile(path$6.toRelativeString());
    }

    private static final File[] deleteFolderT$$anonfun$2$$anonfun$1$$anonfun$1() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    private static final List deleteFolderT$$anonfun$2$$anonfun$1(File file$1) {
        if (file$1.isDirectory()) {
            return Predef$.MODULE$.wrapRefArray((Object[])Option$.MODULE$.apply((Object)file$1.listFiles()).getOrElse(LocalRepositoryInterface::deleteFolderT$$anonfun$2$$anonfun$1$$anonfun$1)).toList();
        }
        return package$.MODULE$.Nil();
    }

    private final boolean canReadT$$anonfun$1(Path path$9) {
        return this.newFile(path$9.toRelativeString()).canRead();
    }

    private final boolean canWriteT$$anonfun$1(Path path$10) {
        return this.newFile(path$10.toRelativeString()).canWrite();
    }
}

