/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.http;

import com.elixirtech.http.IFileAction;
import com.elixirtech.http.IFileActionFactory;
import com.elixirtech.v2.repository.FileObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AddActionFactory
implements IFileActionFactory {
    private List<IFileActionFactory> m_AddFactories = new ArrayList<IFileActionFactory>();

    public void registerAddFactory(IFileActionFactory iFileActionFactory) {
        this.m_AddFactories.add(iFileActionFactory);
    }

    @Override
    public boolean hasFileActions(FileObject fileObject) {
        return this.m_AddFactories.size() > 0;
    }

    @Override
    public void buildFileActions(FileObject fileObject, List<IFileAction> list) {
        ArrayList<IFileAction> arrayList = new ArrayList<IFileAction>();
        this.buildAddFileActions(fileObject, arrayList);
        if (arrayList.size() > 0) {
            list.add(new AddFileAction(fileObject));
        }
    }

    public void buildAddFileActions(FileObject fileObject, List<IFileAction> list) {
        for (IFileActionFactory iFileActionFactory : this.m_AddFactories) {
            iFileActionFactory.buildFileActions(fileObject, list);
        }
    }

    class AddFileAction
    implements IFileAction {
        private final FileObject m_FO;

        public AddFileAction(FileObject fileObject) {
            this.m_FO = fileObject;
        }

        @Override
        public String getActionMethod() {
            return "GET";
        }

        @Override
        public Map<String, String> getActionParameters() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("mode", "add");
            return hashMap;
        }

        @Override
        public String getActionURL() {
            return this.m_FO.getName();
        }

        @Override
        public String getName() {
            return "Add...";
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getImageURL() {
            return null;
        }
    }
}

