/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.http;

import com.elixirtech.http.IFileAction;
import com.elixirtech.http.IFileActionFactory;
import com.elixirtech.http.IFileType;
import com.elixirtech.v2.repository.FileObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpFileTypeManager {
    private static List<IFileActionFactory> m_FolderFactories = new ArrayList<IFileActionFactory>();
    private static Map<String, IFileType> m_FileTypes = new HashMap<String, IFileType>();

    public static IFileType getFileType(String string) {
        if (string == null) {
            return null;
        }
        return m_FileTypes.get(string.toLowerCase());
    }

    public static void addFileType(IFileType iFileType) {
        m_FileTypes.put(iFileType.getExtension(), iFileType);
    }

    public static List<IFileAction> getFileActions(FileObject fileObject) {
        ArrayList<IFileAction> arrayList = new ArrayList<IFileAction>();
        for (IFileActionFactory iFileActionFactory : m_FolderFactories) {
            iFileActionFactory.buildFileActions(fileObject, arrayList);
        }
        return arrayList;
    }

    public static void addFileActionFactory(IFileActionFactory iFileActionFactory) {
        m_FolderFactories.add(iFileActionFactory);
    }

    public static void removeFileActionFactory(IFileActionFactory iFileActionFactory) {
        m_FolderFactories.remove(iFileActionFactory);
    }

    public static <T> T getFileActionFactory(Class<T> clazz) {
        for (IFileActionFactory iFileActionFactory : m_FolderFactories) {
            if (!clazz.isAssignableFrom(iFileActionFactory.getClass())) continue;
            return clazz.cast(iFileActionFactory);
        }
        return null;
    }
}

