/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.i18n;

import com.elixirtech.util.StrBuffer;
import com.elixirtech.util.StringUtil;
import java.text.ParseException;
import java.util.Locale;

public class AcceptLanguage
implements Comparable<AcceptLanguage> {
    public static final Float DEFAULT_PREFERENCE = Float.valueOf("1");
    private Locale m_Locale;
    private Float m_Preference;

    public AcceptLanguage(Locale locale) {
        this(locale, DEFAULT_PREFERENCE);
    }

    public AcceptLanguage(Locale locale, Float f) {
        this.m_Locale = locale;
        this.m_Preference = f;
        if (StringUtil.isEmpty(locale.getLanguage())) {
            throw new IllegalArgumentException("There is no language setting in the given locale.");
        }
    }

    public String toString() {
        StrBuffer strBuffer = new StrBuffer();
        String string = this.m_Locale.getLanguage();
        String string2 = this.m_Locale.getCountry();
        String string3 = this.m_Locale.getVariant();
        strBuffer.append(string);
        if (StringUtil.notEmpty(string2)) {
            strBuffer.append("-");
            strBuffer.append(string2);
        }
        if (StringUtil.notEmpty(string3)) {
            strBuffer.append("-");
            strBuffer.append(string3);
        }
        if (!DEFAULT_PREFERENCE.equals(this.m_Preference)) {
            strBuffer.append(";q=");
            strBuffer.append(this.m_Preference.toString());
        }
        return strBuffer.toString();
    }

    @Override
    public int compareTo(AcceptLanguage acceptLanguage) {
        return this.m_Preference.compareTo(acceptLanguage.getPreference());
    }

    public Locale getLocale() {
        return this.m_Locale;
    }

    public Float getPreference() {
        return this.m_Preference;
    }

    public static AcceptLanguage parse(String string) throws ParseException {
        if (StringUtil.isEmpty(string)) {
            throw new ParseException("The language-tag is empty.", 0);
        }
        String[] stringArray = string.trim().split(";");
        Locale locale = AcceptLanguage.parseLocale(stringArray[0]);
        Float f = DEFAULT_PREFERENCE;
        if (stringArray.length == 2) {
            f = AcceptLanguage.prasePreference(stringArray[1]);
        }
        return new AcceptLanguage(locale, f);
    }

    private static Float prasePreference(String string) {
        if (StringUtil.isEmpty(string)) {
            return DEFAULT_PREFERENCE;
        }
        String[] stringArray = string.split("=");
        if (stringArray.length != 2) {
            return DEFAULT_PREFERENCE;
        }
        try {
            return Float.valueOf(stringArray[1].trim());
        }
        catch (NumberFormatException numberFormatException) {
            return DEFAULT_PREFERENCE;
        }
    }

    private static Locale parseLocale(String string) throws ParseException {
        if (StringUtil.isEmpty(string)) {
            throw new ParseException("The language-tag is empty.", 0);
        }
        String[] stringArray = string.split("-");
        if (stringArray.length == 1) {
            return new Locale(stringArray[0]);
        }
        if (stringArray.length == 2) {
            if (stringArray[1].length() == 2) {
                return new Locale(stringArray[0], stringArray[1]);
            }
            return new Locale(stringArray[0], "", stringArray[1]);
        }
        return new Locale(stringArray[0], stringArray[1], stringArray[2]);
    }
}

