/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.i18n;

import com.elixirtech.i18n.AcceptLanguage;
import com.elixirtech.util.StrBuffer;
import com.elixirtech.util.StringUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class AcceptLanguageHeader {
    private List<AcceptLanguage> m_AcceptList = new ArrayList<AcceptLanguage>();

    public void addAcceptLanguage(AcceptLanguage acceptLanguage) {
        this.m_AcceptList.add(acceptLanguage);
    }

    public void addAcceptLanguages(List<AcceptLanguage> list) {
        this.m_AcceptList.addAll(list);
    }

    public void sortByPreference() {
        Collections.sort(this.m_AcceptList, Collections.reverseOrder());
    }

    public List<Locale> getLocales() {
        this.sortByPreference();
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        for (AcceptLanguage acceptLanguage : this.m_AcceptList) {
            arrayList.add(acceptLanguage.getLocale());
        }
        return arrayList;
    }

    public String toString() {
        StrBuffer strBuffer = new StrBuffer();
        Iterator<AcceptLanguage> iterator = this.m_AcceptList.iterator();
        while (iterator.hasNext()) {
            strBuffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            strBuffer.append(',');
        }
        return strBuffer.toString();
    }

    public static AcceptLanguageHeader parse(String string) throws ParseException {
        String[] stringArray;
        AcceptLanguageHeader acceptLanguageHeader = new AcceptLanguageHeader();
        if (StringUtil.isEmpty(string)) {
            return acceptLanguageHeader;
        }
        for (String string2 : stringArray = string.split(",")) {
            try {
                AcceptLanguage acceptLanguage = AcceptLanguage.parse(string2);
                acceptLanguageHeader.addAcceptLanguage(acceptLanguage);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return acceptLanguageHeader;
    }
}

