/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.i18n;

import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.I18NName;
import com.elixirtech.i18n.Name;
import com.elixirtech.i18n.ResourceBundleLookup;
import com.elixirtech.util.StringUtil;
import com.elixirtech.util.VariableSubstitution;
import java.awt.Image;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class I18NUtil {
    public static String[] getStrings(ResourceBundle resourceBundle, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = resourceBundle.getString(stringArray[i]);
        }
        return stringArray2;
    }

    public static Name[] getNames(ResourceBundle resourceBundle, String[] stringArray) {
        Name[] nameArray = new Name[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nameArray[i] = I18NName.apply((String)stringArray[i], (ResourceBundle)resourceBundle, (String)stringArray[i]);
        }
        return nameArray;
    }

    public static String getString(ResourceBundle resourceBundle, String string, Object ... objectArray) {
        String string2 = resourceBundle.getString(string);
        if (StringUtil.isEmpty(string2)) {
            return string2;
        }
        string2 = string2.replace("'", "''");
        return MessageFormat.format(string2, objectArray);
    }

    public static ImageIcon getIcon(ResourceBundle resourceBundle, String string) {
        String string2 = resourceBundle.getString(string + ".Icon");
        string2 = VariableSubstitution.substitute(string2, new ResourceBundleLookup(resourceBundle));
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL uRL = classLoader.getResource(string2);
            if (uRL == null) {
                return null;
            }
            return new ImageIcon(uRL);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ImageIcon scale(ImageIcon imageIcon, int n) {
        if (imageIcon == null) {
            return null;
        }
        Image image = imageIcon.getImage();
        Image image2 = image.getScaledInstance(n, n, 4);
        return new ImageIcon(image2);
    }

    public static String getStringOrElse(ResourceBundle resourceBundle, String string, String string2) {
        try {
            return resourceBundle.getString(string);
        }
        catch (Throwable throwable) {
            return string2;
        }
    }

    public static JButton getButton(ResourceBundle resourceBundle, String string) {
        JButton jButton = new JButton(I18NUtil.getStringOrElse(resourceBundle, string, null), I18NUtil.getIcon(resourceBundle, string));
        jButton.setToolTipText(I18NUtil.getString(resourceBundle, string + ".Tip", new Object[0]));
        jButton.setActionCommand(string);
        return jButton;
    }

    public static JButton getButton(ResourceBundle resourceBundle, String string, int n) {
        JButton jButton = new JButton(I18NUtil.getStringOrElse(resourceBundle, string, null), I18NUtil.scale(I18NUtil.getIcon(resourceBundle, string), n));
        jButton.setToolTipText(I18NUtil.getString(resourceBundle, string + ".Tip", new Object[0]));
        jButton.setActionCommand(string);
        return jButton;
    }

    public static String getErrorMsg(String string, Throwable throwable) {
        String string2 = Bundle.BASE.getString("Error.Unknown");
        String string3 = throwable.getLocalizedMessage();
        if (string3 == null) {
            string3 = string2;
        }
        if (throwable.getCause() == null) {
            return I18NUtil.getString(Bundle.BASE, "Error.Details", string, string3);
        }
        String string4 = throwable.getCause().getLocalizedMessage();
        return I18NUtil.getString(Bundle.BASE, "Error.DetailsWithCause", string, string3, string4);
    }
}

