/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.i18n;

import com.elixirtech.arch.param.Template$;
import com.elixirtech.i18n.ResourceConverter;
import com.elixirtech.i18n.ResourceConverter$;
import com.elixirtech.i18n.ResourceConverterException;
import com.elixirtech.i18n.ResourceMap$;
import com.elixirtech.i18n.ResourceMap$LookupException$;
import com.elixirtech.i18n.ResourceMap$PropertyInjectionException$;
import java.awt.Component;
import java.awt.Container;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class ResourceMap
implements Product,
Serializable {
    private final Option parent;
    private final ResourceBundle rb;
    private final HashMap map;
    private final Set keys;

    public static String NULL_RESOURCE() {
        return ResourceMap$.MODULE$.NULL_RESOURCE();
    }

    public static ResourceMap apply(Option<ResourceMap> option, ResourceBundle resourceBundle) {
        return ResourceMap$.MODULE$.apply(option, resourceBundle);
    }

    public static ResourceMap fromProduct(Product product) {
        return ResourceMap$.MODULE$.fromProduct(product);
    }

    public static ResourceMap unapply(ResourceMap resourceMap) {
        return ResourceMap$.MODULE$.unapply(resourceMap);
    }

    public ResourceMap(Option<ResourceMap> parent, ResourceBundle rb) {
        HashMap map;
        Set set;
        block6: {
            Tuple2<HashMap<String, Object>, Set<String>> tuple2;
            block5: {
                this.parent = parent;
                this.rb = rb;
                if (parent == null) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)"parent is null");
                }
                if (rb == null) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)"ResourceBundle is null");
                }
                tuple2 = this.buildInfo();
                if (tuple2 == null) break block5;
                HashMap hashMap = (HashMap)tuple2._1();
                set = (Set)tuple2._2();
                if (!(hashMap instanceof HashMap)) break block5;
                map = hashMap;
                if (set instanceof Set) break block6;
            }
            throw new MatchError(tuple2);
        }
        Set keys = set;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)map, (Object)keys);
        this.map = (HashMap)tuple2._1();
        this.keys = (Set)tuple2._2();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ResourceMap)) return false;
        ResourceMap resourceMap = (ResourceMap)object;
        Option<ResourceMap> option = this.parent();
        Option<ResourceMap> option2 = resourceMap.parent();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        ResourceBundle resourceBundle = this.rb();
        ResourceBundle resourceBundle2 = resourceMap.rb();
        if (resourceBundle == null) {
            if (resourceBundle2 != null) {
                return false;
            }
        } else if (!resourceBundle.equals(resourceBundle2)) return false;
        if (!resourceMap.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ResourceMap;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "ResourceMap";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "parent";
        }
        if (1 == n2) {
            return "rb";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Option<ResourceMap> parent() {
        return this.parent;
    }

    public ResourceBundle rb() {
        return this.rb;
    }

    public HashMap<String, Object> map() {
        return this.map;
    }

    public Set<String> keys() {
        return this.keys;
    }

    private Tuple2<HashMap<String, Object>, Set<String>> buildInfo() {
        Map m = CollectionConverters$.MODULE$.EnumerationHasAsScala(this.rb().getKeys()).asScala().map((Function1 & Serializable)k -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(k);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, this.rb().getObject((String)k));
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return Tuple2$.MODULE$.apply((Object)new HashMap().$plus$plus((IterableOnce)m), (Object)m.keys().toSet().$plus$plus((IterableOnce)this.parent().map((Function1 & Serializable)_$1 -> _$1.keys()).getOrElse(ResourceMap::buildInfo$$anonfun$2)));
    }

    public void injectComponents(String prefix, Component root) {
        this.injectComponent(prefix, root);
        Component component = root;
        if (component instanceof Container) {
            Container c = (Container)component;
            Object object = Predef$.MODULE$.refArrayOps((Object[])c.getComponents());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)_$2 -> this.injectComponents(prefix, (Component)_$2));
            return;
        }
    }

    public String getString(String key) {
        return (String)this.getObject(key, String.class).getOrElse(ResourceMap::getString$$anonfun$1);
    }

    public String getFormattedString(String key, Seq<Object> args) {
        Option<MessageFormat> option = this.getObject(key, MessageFormat.class);
        if (option instanceof Some) {
            MessageFormat format = (MessageFormat)((Some)option).value();
            return format.format(args);
        }
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        throw new MatchError(option);
    }

    public String getValue(String name, String valueType) {
        return this.getString(name);
    }

    private void injectComponent(String prefix, Component component) {
        this.injectObject(prefix, component, component.getName());
    }

    public void injectObject(String prefix, Object obj, String name) {
        if (name != null) {
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(obj.getClass());
            }
            catch (IntrospectionException ex) {
                String msg = "introspection failed";
                PropertyInjectionException re = new PropertyInjectionException(msg, null, obj, null);
                re.initCause(ex);
                throw re;
            }
            Object[] pds = beanInfo.getPropertyDescriptors();
            if (pds != null && pds.length > 0) {
                Object object = Predef$.MODULE$.refArrayOps(pds);
                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)pd -> {
                    String key = null;
                    boolean found = false;
                    if (prefix != null) {
                        key = prefix + name + "." + pd.getName();
                        found = this.keys().contains((Object)key);
                    }
                    if (!found) {
                        key = name + "." + pd.getName();
                        found = this.keys().contains((Object)key);
                    }
                    if (found) {
                        this.injectProperty(obj, (PropertyDescriptor)pd, key);
                        return;
                    }
                });
                return;
            }
            return;
        }
    }

    private void injectProperty(Object obj, PropertyDescriptor pd, String key) {
        Method setter = pd.getWriteMethod();
        Class<?> pType = pd.getPropertyType();
        if (setter != null && pType != null) {
            Option<?> option = this.getObject(key, pType);
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                try {
                    setter.invoke(obj, value);
                }
                catch (Exception ex) {
                    String pdn = pd.getName();
                    String msg = "property setter failed";
                    PropertyInjectionException re = new PropertyInjectionException(msg, key, obj, pdn);
                    re.initCause(ex);
                    throw re;
                }
                return;
            }
            if (None$.MODULE$.equals(option)) {
                String pdn = pd.getName();
                String msg = "no value of type " + pType + " specified for resource";
                throw new PropertyInjectionException(msg, key, obj, pdn);
            }
            throw new MatchError(option);
        }
        String pdn = pd.getName();
        String msg = "can't set read-only property";
        throw new PropertyInjectionException(msg, key, obj, pdn);
    }

    public Option<Tuple2<ResourceMap, Object>> getKeyHolder(String key) {
        return this.map().get((Object)key).map((Function1 & Serializable)value -> Tuple2$.MODULE$.apply((Object)this, value)).orElse(() -> this.getKeyHolder$$anonfun$2(key));
    }

    public <T> Option<T> getObject(String key, Class<T> pType) {
        Tuple2 tuple2;
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (pType == null) {
            throw new IllegalArgumentException("null type");
        }
        Option<Tuple2<ResourceMap, Object>> option = this.getKeyHolder(key);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            String value;
            ResourceMap resourceMap = (ResourceMap)tuple2._1();
            Object object = tuple2._2();
            ResourceMap resourceMapNode = resourceMap;
            if (object == null) {
                return None$.MODULE$;
            }
            ResourceMap resourceMapNode2 = resourceMap;
            if (object instanceof String && (value = (String)object).contains("${")) {
                String str = this.evaluateStringExpression(value);
                return Some$.MODULE$.apply(this.convert(key, resourceMapNode2, str, pType));
            }
            ResourceMap resourceMapNode3 = resourceMap;
            Object value2 = object;
            if (pType.isAssignableFrom(value2.getClass())) {
                return Some$.MODULE$.apply(value2);
            }
            ResourceMap resourceMapNode4 = resourceMap;
            if (object instanceof String) {
                String value3 = (String)object;
                return Some$.MODULE$.apply(this.convert(key, resourceMapNode4, value3, pType));
            }
        }
        String msg = "named resource has wrong type";
        throw new LookupException(msg, key, pType);
    }

    public <T> T convert(String key, ResourceMap node, String value, Class<T> pType) {
        if (pType.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        Option<ResourceConverter<T>> option = ResourceConverter$.MODULE$.forType(pType);
        if (option instanceof Some) {
            ResourceConverter stringConverter = (ResourceConverter)((Some)option).value();
            try {
                Object ret = stringConverter.parseString(value, node);
                node.putResource(key, ret);
                return ret;
            }
            catch (ResourceConverterException ex) {
                String msg = "string conversion failed";
                LookupException lfe = new LookupException(msg, key, pType);
                lfe.initCause(ex);
                throw lfe;
            }
        }
        if (None$.MODULE$.equals(option)) {
            String msg = "no StringConverter for required type";
            throw new LookupException(msg, key, pType);
        }
        throw new MatchError(option);
    }

    public boolean containsResourceKey(String key) {
        return this.map().contains((Object)key);
    }

    public Object getResource(String key) {
        Object value;
        Object object = value = this.map().apply((Object)key);
        String string = ResourceMap$.MODULE$.NULL_RESOURCE();
        if (!(object != null ? !object.equals(string) : string != null)) {
            return null;
        }
        return value;
    }

    public void putResource(String key, Object value) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
        this.map().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, Option$.MODULE$.apply(value).getOrElse(ResourceMap::putResource$$anonfun$1)));
    }

    private String evaluateStringExpression(String expr) {
        if (expr.trim().equals("${null}")) {
            return null;
        }
        return Template$.MODULE$.apply(expr).substitute(this.lookup().lift());
    }

    private PartialFunction<String, String> lookup() {
        return new PartialFunction<String, String>(this){
            private final /* synthetic */ ResourceMap $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                PartialFunction.$init$((PartialFunction)this);
            }

            public boolean isDefinedAt(String key) {
                return this.$outer.keys().contains((Object)key);
            }

            public String apply(String key) {
                return (String)this.$outer.getObject(key, String.class).getOrElse(ResourceMap::com$elixirtech$i18n$ResourceMap$$anon$1$$_$apply$$anonfun$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$elixirtech$i18n$ResourceMap$$anon$1$$_$apply$$anonfun$1()}, serializedLambda);
            }
        };
    }

    public ResourceMap copy(Option<ResourceMap> parent, ResourceBundle rb) {
        return new ResourceMap(parent, rb);
    }

    public Option<ResourceMap> copy$default$1() {
        return this.parent();
    }

    public ResourceBundle copy$default$2() {
        return this.rb();
    }

    public Option<ResourceMap> _1() {
        return this.parent();
    }

    public ResourceBundle _2() {
        return this.rb();
    }

    private static final Set buildInfo$$anonfun$2() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final String getString$$anonfun$1() {
        return null;
    }

    private final Option getKeyHolder$$anonfun$2(String key$1) {
        return this.parent().flatMap((Function1 & Serializable)_$3 -> _$3.getKeyHolder(key$1));
    }

    private static final Object putResource$$anonfun$1() {
        return ResourceMap$.MODULE$.NULL_RESOURCE();
    }

    public static final String com$elixirtech$i18n$ResourceMap$$anon$1$$_$apply$$anonfun$1() {
        return null;
    }

    public static class LookupException
    extends RuntimeException
    implements Product {
        private final String msg;
        private final String key;
        private final Class pType;

        public static LookupException apply(String string, String string2, Class<?> clazz) {
            return ResourceMap$LookupException$.MODULE$.apply(string, string2, clazz);
        }

        public static LookupException fromProduct(Product product) {
            return ResourceMap$LookupException$.MODULE$.fromProduct(product);
        }

        public static LookupException unapply(LookupException lookupException) {
            return ResourceMap$LookupException$.MODULE$.unapply(lookupException);
        }

        public LookupException(String msg, String key, Class<?> pType) {
            this.msg = msg;
            this.key = key;
            this.pType = pType;
            super(msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LookupException)) return false;
            LookupException lookupException = (LookupException)object;
            String string = this.msg();
            String string2 = lookupException.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.key();
            String string4 = lookupException.key();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Class<?> clazz = this.pType();
            Class<?> clazz2 = lookupException.pType();
            if (clazz == null) {
                if (clazz2 != null) {
                    return false;
                }
            } else if (!clazz.equals(clazz2)) return false;
            if (!lookupException.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof LookupException;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "LookupException";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "msg";
                }
                case 1: {
                    return "key";
                }
                case 2: {
                    return "pType";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String msg() {
            return this.msg;
        }

        public String key() {
            return this.key;
        }

        public Class<?> pType() {
            return this.pType;
        }

        public LookupException copy(String msg, String key, Class<?> pType) {
            return new LookupException(msg, key, pType);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String copy$default$2() {
            return this.key();
        }

        public Class<?> copy$default$3() {
            return this.pType();
        }

        public String _1() {
            return this.msg();
        }

        public String _2() {
            return this.key();
        }

        public Class<?> _3() {
            return this.pType();
        }
    }

    public static class PropertyInjectionException
    extends RuntimeException
    implements Product {
        private final String msg;
        private final String key;
        private final Object obj;
        private final String propertyName;

        public static PropertyInjectionException apply(String string, String string2, Object object, String string3) {
            return ResourceMap$PropertyInjectionException$.MODULE$.apply(string, string2, object, string3);
        }

        public static PropertyInjectionException fromProduct(Product product) {
            return ResourceMap$PropertyInjectionException$.MODULE$.fromProduct(product);
        }

        public static PropertyInjectionException unapply(PropertyInjectionException propertyInjectionException) {
            return ResourceMap$PropertyInjectionException$.MODULE$.unapply(propertyInjectionException);
        }

        public PropertyInjectionException(String msg, String key, Object obj, String propertyName) {
            this.msg = msg;
            this.key = key;
            this.obj = obj;
            this.propertyName = propertyName;
            super(msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PropertyInjectionException)) return false;
            PropertyInjectionException propertyInjectionException = (PropertyInjectionException)object;
            String string = this.msg();
            String string2 = propertyInjectionException.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.key();
            String string4 = propertyInjectionException.key();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!BoxesRunTime.equals((Object)this.obj(), (Object)propertyInjectionException.obj())) return false;
            String string5 = this.propertyName();
            String string6 = propertyInjectionException.propertyName();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (!propertyInjectionException.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof PropertyInjectionException;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "PropertyInjectionException";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "msg";
                }
                case 1: {
                    return "key";
                }
                case 2: {
                    return "obj";
                }
                case 3: {
                    return "propertyName";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String msg() {
            return this.msg;
        }

        public String key() {
            return this.key;
        }

        public Object obj() {
            return this.obj;
        }

        public String propertyName() {
            return this.propertyName;
        }

        public PropertyInjectionException copy(String msg, String key, Object obj, String propertyName) {
            return new PropertyInjectionException(msg, key, obj, propertyName);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String copy$default$2() {
            return this.key();
        }

        public Object copy$default$3() {
            return this.obj();
        }

        public String copy$default$4() {
            return this.propertyName();
        }

        public String _1() {
            return this.msg();
        }

        public String _2() {
            return this.key();
        }

        public Object _3() {
            return this.obj();
        }

        public String _4() {
            return this.propertyName();
        }
    }
}

