/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.i18n;

import com.elixirtech.i18n.IUIFactory;
import com.elixirtech.i18n.Name;
import com.elixirtech.i18n.RBWrapper;
import com.elixirtech.util.StringUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;

public class UIFactory
implements IUIFactory,
Serializable {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);

    public static ResourceBundle getBundle(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault(), classLoader);
        return new RBWrapper(resourceBundle);
    }

    @Override
    public String getString(String string, String string2) {
        ResourceBundle resourceBundle = UIFactory.getBundle(string);
        return resourceBundle.getString(string2);
    }

    @Override
    public String[] getStrings(String string, String string2, String[] stringArray) {
        ResourceBundle resourceBundle = UIFactory.getBundle(string);
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = resourceBundle.getString(string2 + stringArray[i]);
        }
        return stringArray2;
    }

    @Override
    public Name[] getNames(String string, String string2, String[] stringArray) {
        ResourceBundle resourceBundle = UIFactory.getBundle(string);
        Name[] nameArray = new Name[stringArray.length];
        for (int i = 0; i < nameArray.length; ++i) {
            nameArray[i] = new Name(resourceBundle.getString(string2 + stringArray[i]));
        }
        return nameArray;
    }

    @Override
    public String getString(String string, String string2, Object[] objectArray) {
        return MessageFormat.format(this.getString(string, string2), objectArray);
    }

    @Override
    public String getString(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string3};
        return MessageFormat.format(this.getString(string, string2), objectArray);
    }

    @Override
    public String getTip(String string, String string2) {
        return this.getString(string, string2 + ".Tip");
    }

    @Override
    public JButton newButton(String string, String string2, String string3) {
        JButton jButton = new JButton();
        jButton.setText(this.getString(string, string2));
        jButton.setActionCommand(string2);
        if (StringUtil.notEmpty(string3)) {
            jButton.setToolTipText(this.getString(string, string3));
        }
        return jButton;
    }

    @Override
    public JButton newButton(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton();
        jButton.setText(this.getString(string, string2));
        jButton.setActionCommand(string2);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        return jButton;
    }

    @Override
    public JCheckBox newCheckBox() {
        return new JCheckBox();
    }

    @Override
    public JCheckBox newCheckBox(String string, String string2) {
        return new JCheckBox(this.getString(string, string2));
    }

    @Override
    public JCheckBox newCheckBox(String string, String string2, boolean bl) {
        return new JCheckBox(this.getString(string, string2), bl);
    }

    @Override
    public JComboBox newComboBox(String[] stringArray) {
        return new JComboBox<String>(stringArray);
    }

    @Override
    public JComboBox newComboBox(ResourceBundle resourceBundle, Vector vector) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(vector);
        jComboBox.setRenderer(new I18NCellRenderer(resourceBundle));
        return jComboBox;
    }

    @Override
    public JComboBox newComboBox(ResourceBundle resourceBundle, String[] stringArray) {
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setRenderer(new I18NCellRenderer(resourceBundle));
        return jComboBox;
    }

    @Override
    public JComboBox newComboBox(ResourceBundle resourceBundle, Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setRenderer(new I18NCellRenderer(resourceBundle));
        return jComboBox;
    }

    @Override
    public JComboBox newLocaleComboBox(String string, Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setRenderer(new LocaleCellRenderer(string));
        return jComboBox;
    }

    @Override
    public JLabel newLabel(String string, String string2) {
        return new JLabel(this.getString(string, string2));
    }

    @Override
    public JRadioButton newRadioButton() {
        return new JRadioButton();
    }

    @Override
    public JRadioButton newRadioButton(String string, String string2) {
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setText(this.getString(string, string2));
        jRadioButton.setActionCommand(string2);
        return jRadioButton;
    }

    @Override
    public JToggleButton newToggleButton(String string, Action action) {
        JToggleButton jToggleButton = new JToggleButton((Icon)action.getValue("SmallIcon"));
        jToggleButton.setActionCommand("ActionCommandKey");
        jToggleButton.setToolTipText(action.getValue("Name").toString());
        return jToggleButton;
    }

    public static final class I18NCellRenderer
    extends JLabel
    implements ListCellRenderer<Object>,
    TableCellRenderer {
        private ResourceBundle m_RB;

        public I18NCellRenderer(ResourceBundle resourceBundle) {
            this.setOpaque(true);
            this.m_RB = resourceBundle;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            this.setFont(jList.getFont());
            String string2 = string = object != null ? object.toString() : null;
            if (StringUtil.notEmpty(string)) {
                this.setText(this.m_RB.getString(string));
            } else {
                this.setText(string);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            this.setFont(jTable.getFont());
            String string2 = string = object != null ? object.toString() : null;
            if (StringUtil.notEmpty(string)) {
                this.setText(this.m_RB.getString(string));
            } else {
                this.setText(string);
            }
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            return this;
        }
    }

    public static final class LocaleCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private String m_Module;

        public LocaleCellRenderer(String string) {
            this.setOpaque(true);
            this.m_Module = string;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setFont(jList.getFont());
            try {
                String string = object.toString();
                if (string.equals("Template Locale") || string.equals("Default Locale")) {
                    ResourceBundle resourceBundle = UIFactory.getBundle(this.m_Module);
                    string = resourceBundle.getString(string);
                }
                this.setText(string);
                if (bl) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
            }
            catch (Exception exception) {
                System.err.println("Exception : " + String.valueOf(exception));
            }
            return this;
        }
    }
}

