/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.mongodb;

import com.elixirtech.mongodb.MDBConfig;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.mongodb.scala.MongoClient;
import org.mongodb.scala.MongoClient$;
import org.mongodb.scala.MongoClientSettings$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;

public final class StandardMongoDB$
implements Serializable {
    private static final Regex ConnectionRegEx;
    public static final StandardMongoDB$ MODULE$;

    private StandardMongoDB$() {
    }

    static {
        MODULE$ = new StandardMongoDB$();
        ConnectionRegEx = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("mongodb:\\/\\/([^:]+):([^@]+)@(.*)"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StandardMongoDB$.class);
    }

    public Regex ConnectionRegEx() {
        return ConnectionRegEx;
    }

    public MongoClient buildMongoClient(MDBConfig mdb) {
        MongoClientSettings.Builder b1 = MongoClientSettings$.MODULE$.builder().codecRegistry(MongoClient$.MODULE$.DEFAULT_CODEC_REGISTRY()).applyConnectionString(new ConnectionString(mdb.connectionString()));
        MongoClientSettings.Builder b2 = this.withX509(mdb, b1);
        return MongoClient$.MODULE$.apply(b2.build());
    }

    public MongoClientSettings.Builder withX509(MDBConfig mdb, MongoClientSettings.Builder builder2) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(mdb.keystoreFile()))) {
            return builder2.applyToSslSettings(builder -> builder.enabled(true).context(MODULE$.ssl(mdb)));
        }
        return builder2;
    }

    public SSLContext ssl(MDBConfig mdb) {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(this.keyManagerFactory(mdb).getKeyManagers(), null, new SecureRandom());
        return sslContext;
    }

    public KeyManagerFactory keyManagerFactory(MDBConfig mdb) {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(this.keyStore(mdb), mdb.keystorePassword().toCharArray());
        return kmf;
    }

    public KeyStore keyStore(MDBConfig mdb) {
        KeyStore ks = KeyStore.getInstance(mdb.keystoreFileType());
        byte[] bytes = Files.readAllBytes(new File(mdb.keystoreFile()).toPath());
        ks.load(new ByteArrayInputStream(bytes), (char[])StringOps$.MODULE$.toArray$extension(Predef$.MODULE$.augmentString(mdb.keystorePassword()), ClassTag$.MODULE$.apply(Character.TYPE)));
        return ks;
    }
}

