/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.doc;

import ambience.docxengine.aspose.AsposeWords;
import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.MimeInfo;
import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.arch.mime.IMIMEManager;
import com.elixirtech.arch.mime.MIMEEntry;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.IRepositoryActions;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.wizard.RenameFileWizard;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.ParameterUtil;
import com.elixirtech.ensemble.wizard.ParameterUI;
import com.elixirtech.opc.doc.DocXAction;
import com.elixirtech.opc.doc.Icons;
import com.elixirtech.opc.docprocessor.DocRenderContext;
import com.elixirtech.opc.docprocessor.LocalResourceLoader;
import com.elixirtech.opc.docprocessor.Processor;
import com.elixirtech.opc.docprocessor.ResourceLoader;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.v2.repository.FileObject;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;

public class DOCXFileType
extends FileType {
    public static final String MIME_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    protected static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DOCXFileType.class);

    public DOCXFileType() {
        super("Microsoft Word 2007", "docx", Icons.DOCX, RepositoryExplorer.FILE_FLAVOR());
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public Action getAddAction(FileObject fileObject) {
        return null;
    }

    @Override
    public Action getPropertiesAction(FileObject fileObject) {
        return null;
    }

    @Override
    public Action getDefaultAction(FileObject fileObject) {
        IMIMEManager iMIMEManager = (IMIMEManager)Elixir.get(IMIMEManager.class);
        MIMEEntry mIMEEntry = iMIMEManager.getEntryForFilename("docx");
        if (mIMEEntry != null) {
            IRepositoryActions iRepositoryActions = (IRepositoryActions)Elixir.get(IRepositoryActions.class);
            return iRepositoryActions.getOpenExternalAction(fileObject, mIMEEntry);
        }
        return null;
    }

    @Override
    public Action[] getPopupActions(FileObject fileObject) {
        Action[] actionArray;
        IMIMEManager iMIMEManager = (IMIMEManager)Elixir.get(IMIMEManager.class);
        MIMEEntry mIMEEntry = iMIMEManager.getEntryForFilename("docx");
        if (mIMEEntry != null) {
            if (AsposeWords.asposeEnabled()) {
                IRepositoryActions iRepositoryActions = (IRepositoryActions)Elixir.get(IRepositoryActions.class);
                actionArray = new Action[]{iRepositoryActions.getOpenExternalAction(fileObject, mIMEEntry), new RenameFile(fileObject), new RenderAsposeReport("Repository.RenderReportDocX", MimeTypes.DOCX(), fileObject), new RenderAsposeReport("Repository.RenderReportPDF", MimeTypes.PDF(), fileObject)};
            } else {
                IRepositoryActions iRepositoryActions = (IRepositoryActions)Elixir.get(IRepositoryActions.class);
                actionArray = new Action[]{iRepositoryActions.getOpenExternalAction(fileObject, mIMEEntry), new RenderReport(fileObject), new RenameFile(fileObject)};
            }
        } else {
            actionArray = new Action[]{};
        }
        return actionArray;
    }

    @Override
    public IPanelView createView(FileObject fileObject) {
        return null;
    }

    @Override
    public Icon getRenderableIcon() {
        return Icons.DOCX;
    }

    protected Map<String, String> buildDynamicParameters(Processor processor) {
        ArgumentMap argumentMap = new ArgumentMap();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object object : processor.getParameters().values()) {
            argumentMap.extractParameters((String)object);
        }
        List list = argumentMap.getParameters();
        if (ParameterUtil.getParamCount((List)list) > 0) {
            Object object;
            object = new ParameterUI(list, null);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard((IWizard)object);
            if (((Wizard)object).isFinished()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Parameter parameter = (Parameter)iterator.next();
                    String string = ((ParameterUI)object).getValue(parameter.getName());
                    if (string == null) continue;
                    hashMap.put(parameter.getName(), string);
                }
                return hashMap;
            }
            return null;
        }
        return hashMap;
    }

    protected class RenameFile
    extends DocXAction {
        private FileObject m_FileObject;

        public RenameFile(FileObject fileObject) {
            super("Repository.RenameFile");
            this.m_FileObject = fileObject;
            this.setEnabled(this.m_FileObject.canWrite());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            m_Log.info((Object)("rename file " + String.valueOf(this.m_FileObject.getPath())));
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(new RenameFileWizard(this.m_FileObject));
        }
    }

    protected class RenderAsposeReport
    extends DocXAction {
        private FileObject m_FileObject;
        private MimeType m_MimeType;

        public RenderAsposeReport(String string, MimeType mimeType, FileObject fileObject) {
            super(string);
            this.m_FileObject = fileObject;
            this.m_MimeType = mimeType;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            m_Log.info((Object)("render report " + String.valueOf(this.m_FileObject.getPath()) + " with mimeType " + String.valueOf(this.m_MimeType)));
            DocRenderContext docRenderContext = new DocRenderContext();
            LocalResourceLoader localResourceLoader = new LocalResourceLoader();
            try {
                byte[] byArray = this.m_FileObject.getInputStream().readAllBytes();
                Processor processor = new Processor(byArray, (ResourceLoader)localResourceLoader);
                Map<String, String> map = DOCXFileType.this.buildDynamicParameters(processor);
                if (map != null) {
                    map.put("mimeType", this.m_MimeType.value());
                    File file = File.createTempFile("elx", "." + MimeInfo.extension((MimeType)this.m_MimeType));
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    processor.render(docRenderContext, map, (OutputStream)fileOutputStream);
                    ((OutputStream)fileOutputStream).close();
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (IOException iOException) {
                        m_Log.error((Object)("Error opening file: " + String.valueOf(iOException)), (Throwable)iOException);
                        ElixirJ.userError("Error opening file: " + String.valueOf(iOException));
                    }
                }
            }
            catch (Exception exception) {
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).error("Error processing docx", (Throwable)exception);
            }
        }
    }

    protected class RenderReport
    extends DocXAction {
        private FileObject m_FileObject;

        public RenderReport(FileObject fileObject) {
            super("Repository.RenderReport");
            this.m_FileObject = fileObject;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            m_Log.info((Object)("render report " + String.valueOf(this.m_FileObject.getPath())));
            DocRenderContext docRenderContext = new DocRenderContext();
            LocalResourceLoader localResourceLoader = new LocalResourceLoader();
            try {
                byte[] byArray = this.m_FileObject.getInputStream().readAllBytes();
                Processor processor = new Processor(byArray, (ResourceLoader)localResourceLoader);
                Map<String, String> map = DOCXFileType.this.buildDynamicParameters(processor);
                if (map != null) {
                    File file = File.createTempFile("elx", ".docx");
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    processor.render(docRenderContext, map, (OutputStream)fileOutputStream);
                    ((OutputStream)fileOutputStream).close();
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (IOException iOException) {
                        m_Log.error((Object)("Error opening file: " + String.valueOf(iOException)), (Throwable)iOException);
                        ElixirJ.userError("Error opening file: " + String.valueOf(iOException));
                    }
                }
            }
            catch (Exception exception) {
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).error("Error processing docx", (Throwable)exception);
            }
        }
    }
}

